/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.rms;

import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import ole.pstros.ConfigData;
import ole.pstros.rms.RmsGroup;
import ole.pstros.rms.RmsManager;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class RmsReader
extends DefaultHandler {
    private RmsManager manager;

    public void readRms() {
        if (ConfigData.readOnly) {
            return;
        }
        this.manager = RmsManager.getInstance();
        File file = new File(this.manager.getDataFilename());
        if (!file.exists()) {
            return;
        }
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse(file, (DefaultHandler)this);
        }
        catch (Exception e2) {
            System.out.println("Error:RmsReader:" + e2);
        }
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        Object item = null;
        String appName = null;
        String name = null;
        String data = null;
        String auth = null;
        int dataCount = 0;
        Vector<String> v = null;
        if (qName.equals("record")) {
            int size = attributes.getLength();
            int i2 = 0;
            while (i2 < size) {
                String attrName = attributes.getQName(i2);
                if (attrName.equals("application")) {
                    appName = attributes.getValue(i2);
                    ++dataCount;
                } else if (attrName.equals("name")) {
                    name = attributes.getValue(i2);
                    ++dataCount;
                } else if (attrName.equals("auth")) {
                    auth = attributes.getValue(i2);
                } else if (attrName.equals("data")) {
                    data = attributes.getValue(i2);
                    ++dataCount;
                } else if (attrName.startsWith("data")) {
                    if (v == null) {
                        v = new Vector<String>();
                    }
                    v.add(attributes.getValue(i2));
                }
                ++i2;
            }
            if (dataCount == 3) {
                this.createRmsGroup(appName, name, data, auth);
            } else if (dataCount >= 2 && v != null) {
                this.createRmsGroup(appName, name, v, auth);
            }
        }
    }

    private void createRmsGroup(String appName, String name, Object data, String auth) {
        RmsGroup result;
        boolean publicAuth = false;
        if (auth != null && (auth.equals("public") || auth.equals("1"))) {
            publicAuth = true;
        }
        if ((result = this.manager.getRmsGroup(appName, name, publicAuth, true)) == null) {
            return;
        }
        if (data instanceof String) {
            byte[] buff = this.getByteArray((String)data);
            result.addRecord(buff);
        } else if (data instanceof Vector) {
            Vector v = (Vector)data;
            int size = v.size();
            int i2 = 0;
            while (i2 < size) {
                byte[] buff = this.getByteArray((String)v.get(i2));
                result.addRecord(buff);
                ++i2;
            }
        }
    }

    private byte[] getByteArray(String data) {
        StringTokenizer tokenizer = new StringTokenizer(data, " ");
        int size = tokenizer.countTokens();
        byte[] buff = new byte[size];
        int i2 = 0;
        while (i2 < size) {
            buff[i2] = (byte)Integer.parseInt(tokenizer.nextToken());
            ++i2;
        }
        return buff;
    }
}

