/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.StringTokenizer;
import ole.pstros.MainApp;
import ole.pstros.utils.BaseClassLoader;

public class DirectoryClassLoader
extends BaseClassLoader {
    File baseDirectory;
    String[] dirs;

    public DirectoryClassLoader(ClassLoader masterCl) {
        super(masterCl);
        String baseDir = System.getProperty("pstros.dcl.dir");
        if (baseDir == null) {
            baseDir = "./;./data";
        }
        this.setBaseDir(baseDir);
    }

    public DirectoryClassLoader(String baseDir) {
        this.setBaseDir(baseDir);
    }

    private void setBaseDir(String baseDir) {
        StringTokenizer tokenizer = new StringTokenizer(baseDir, ";");
        int size = tokenizer.countTokens();
        this.dirs = new String[size];
        int i2 = 0;
        while (i2 < size) {
            this.dirs[i2] = tokenizer.nextToken();
            ++i2;
        }
        try {
            this.baseDirectory = new File("./");
            if (!this.baseDirectory.exists() || !this.baseDirectory.isDirectory()) {
                this.baseDirectory = null;
            }
        }
        catch (Exception e2) {
            System.out.println("Error:" + this.getClass().toString() + " : " + e2);
            System.out.println(" dir=" + baseDir);
        }
    }

    private String getFilename(String name) {
        try {
            int i2 = 0;
            while (i2 < this.dirs.length) {
                File file;
                String path = this.baseDirectory.getCanonicalPath();
                String dir = this.dirs[i2];
                if (dir.charAt(0) != '/' || dir.charAt(0) != '\\') {
                    path = String.valueOf(path) + '/';
                }
                path = String.valueOf(path) + dir;
                if (name.charAt(0) != '/' || name.charAt(0) != '\\') {
                    path = String.valueOf(path) + '/';
                }
                if ((file = new File(path = String.valueOf(path) + name)).exists() && !file.isDirectory()) {
                    return path;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            System.out.println("Error:" + this.getClass().toString() + " : " + e2);
            System.out.println("  loadData: name=" + name);
        }
        return null;
    }

    protected byte[] loadData(String name) {
        String path;
        block6: {
            if (this.dirs == null) {
                return null;
            }
            path = this.getFilename(name);
            if (path != null) break block6;
            return null;
        }
        try {
            File file = new File(path);
            int size = (int)file.length();
            FileInputStream stream = new FileInputStream(file);
            int offset = 0;
            int red = 0;
            byte[] result = new byte[size];
            while (size > 0) {
                red = ((InputStream)stream).read(result, offset, size);
                size -= red;
                offset += red;
            }
            if (MainApp.verbose) {
                System.out.println("DCL loadData name= " + name);
            }
            return result;
        }
        catch (Exception e2) {
            System.out.println("Error:" + this.getClass().toString() + " : " + e2);
            System.out.println("  loadData: name=" + name);
            return null;
        }
    }

    public URL getResource(String name) {
        if (MainApp.verbose) {
            System.out.println("Pstros DirectoryClassLoader: getResource called name=" + name);
        }
        return this.getUrl(name);
    }

    protected URL findResource(String name) {
        if (MainApp.verbose) {
            System.out.println("Pstros DirectoryClassLoader: findResource called name=" + name);
        }
        return this.getUrl(name);
    }

    private URL getUrl(String name) {
        String filename = this.getFilename(name);
        if (filename == null) {
            return null;
        }
        URL url = null;
        try {
            url = new URL("pstros:///" + name);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (MainApp.verbose) {
            System.out.println("url=" + url);
        }
        return url;
    }
}

