/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ScrollPaneAdjustable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import ole.pstros.ConfigData;
import ole.pstros.EmuCanvas;
import ole.pstros.IEmuBridge;
import ole.pstros.utils.ImageCreator;
import ole.pstros.utils.TgaWriter;

public class ImageViewer
extends Canvas
implements WindowListener,
MouseListener,
AdjustmentListener {
    private static final boolean SHOW_TRANSFORM = false;
    private static Color COLOR_WHITE = new Color(0xFFFFFF);
    private static Color COLOR_BLACK = new Color(0);
    private static Color COLOR_GRAY = new Color(0x9F9F9F);
    private static int imgCounter;
    private static final int[] tmpData;
    private Vector images;
    private Frame parent;
    private Container container;
    private ScrollPaneAdjustable vScroll;
    private int mouseX;
    private int mouseY;
    private int infoX;
    private int infoY;
    private int infoH;
    private int fontAscent;
    private int offsetY;
    private javax.microedition.lcdui.Image selectedImage;

    static {
        tmpData = new int[1];
    }

    public ImageViewer(Vector images, Frame parent, Container container) {
        this.setBackground(COLOR_GRAY);
        this.images = images;
        this.parent = parent;
        this.container = container;
        this.addMouseListener(this);
        this.infoY = -1;
    }

    public void paint(Graphics g2) {
        int size = this.images.size();
        int w = this.getWidth() + 16;
        int posY = 2;
        int imgCount = 1;
        if (this.infoH < 1) {
            FontMetrics fm = g2.getFontMetrics();
            this.infoH = fm.getHeight() + 5;
            this.fontAscent = fm.getAscent() + 2;
        }
        IEmuBridge bridge = EmuCanvas.instance.lcduiBridge;
        int i2 = 0;
        while (i2 < size) {
            javax.microedition.lcdui.Image image = (javax.microedition.lcdui.Image)this.images.get(i2);
            int h2 = image.getHeight();
            g2.setColor(COLOR_GRAY);
            g2.fillRect(0, posY - 2, w, h2 + 5);
            g2.setColor(COLOR_BLACK);
            int posX = 5;
            int j2 = 0;
            while (j2 < imgCount) {
                ImageViewer.tmpData[0] = j2;
                Image img = (Image)bridge.handleEvent(20, image, tmpData);
                if (img != null) {
                    g2.drawImage(img, posX, posY, null);
                }
                ++j2;
            }
            g2.setColor(COLOR_BLACK);
            g2.drawLine(2, posY += h2 + 2, w - 20, posY);
            posY += 3;
            ++i2;
        }
        if (this.infoY > -1 && this.selectedImage != null) {
            int imW = this.selectedImage.getWidth();
            int imH = this.selectedImage.getHeight();
            g2.setColor(COLOR_WHITE);
            g2.fillRect(this.infoX, this.infoY, 128, this.infoH);
            g2.setColor(COLOR_BLACK);
            g2.drawString(String.valueOf(Integer.toString(imW)) + "x" + Integer.toString(imH) + " [" + Integer.toString(imW * imH) + "]", this.infoX + 4, this.infoY + this.fontAscent);
            g2.drawRect(this.infoX, this.infoY, 127, this.infoH - 1);
        }
    }

    public void setVerticalScroll(ScrollPaneAdjustable spa) {
        this.vScroll = spa;
        this.vScroll.addAdjustmentListener(this);
    }

    public Dimension getSize() {
        if (this.images == null) {
            return super.getSize();
        }
        int size = this.images.size();
        int posY = 0;
        int posX = 0;
        posY += 2;
        int i2 = 0;
        while (i2 < size) {
            javax.microedition.lcdui.Image image = (javax.microedition.lcdui.Image)this.images.get(i2);
            int h2 = image.getHeight();
            int w = image.getWidth() + 10;
            posY += h2 + 5;
            if (w > posX) {
                posX = w;
            }
            ++i2;
        }
        return new Dimension(posX, posY);
    }

    private javax.microedition.lcdui.Image getImageAt(int y) {
        if (this.images == null) {
            return null;
        }
        javax.microedition.lcdui.Image image = null;
        int size = this.images.size();
        int posY = 0;
        posY += 2;
        int i2 = 0;
        while (i2 < size && posY < y) {
            image = (javax.microedition.lcdui.Image)this.images.get(i2);
            int h2 = image.getHeight();
            posY += h2 + 5;
            ++i2;
        }
        return image;
    }

    public void windowActivated(WindowEvent e2) {
        this.requestFocus();
    }

    public void windowClosed(WindowEvent e2) {
        System.out.println("closed");
        this.parent.removeWindowListener(this);
        this.images.removeAllElements();
        this.selectedImage = null;
    }

    public void windowClosing(WindowEvent e2) {
        System.out.println("Closing!");
        ConfigData.imageViewerBounds = this.parent.getBounds();
        this.parent.dispose();
    }

    public void windowDeactivated(WindowEvent e2) {
    }

    public void windowDeiconified(WindowEvent e2) {
    }

    public void windowIconified(WindowEvent e2) {
    }

    public void windowOpened(WindowEvent e2) {
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void mousePressed(MouseEvent e2) {
        int button = e2.getButton();
        int modifiers = e2.getModifiers();
        this.mouseY = e2.getY();
        this.mouseX = e2.getX();
        this.selectedImage = this.getImageAt(this.mouseY);
        if (this.selectedImage == null) {
            return;
        }
        if (button == 1) {
            this.infoX = this.mouseX;
            this.infoY = this.mouseY - this.infoH;
            if (this.infoY < 0) {
                this.infoY = 0;
            }
            this.repaint(this.infoX, this.infoY, 128, this.infoH);
        } else if (button == 3 && (modifiers & 2) != 0) {
            System.out.print("Save image...");
            ImageViewer.tmpData[0] = 0;
            IEmuBridge bridge = EmuCanvas.instance.lcduiBridge;
            Image img = (Image)bridge.handleEvent(20, this.selectedImage, tmpData);
            BufferedImage bi = null;
            bi = ImageCreator.createBufferedImage(img);
            String name = TgaWriter.saveImageTransparent("iw", bi, this.selectedImage.getWidth(), this.selectedImage.getHeight(), 0, imgCounter);
            if (name != null) {
                ++imgCounter;
                System.out.println("ok. " + name);
            } else {
                System.out.println("failed!");
            }
        }
    }

    public void mouseReleased(MouseEvent e2) {
        this.infoY = -1;
        this.repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent e2) {
        this.offsetY = e2.getValue();
    }
}

