/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.HashMap;
import java.util.StringTokenizer;

public class JadFileParser {
    private static String TAG_JAR = "MIDlet-Jar-URL";
    private static String TAG_NAME = "MIDlet-Name";
    private static String TAG_CLASS = "MIDlet-1";
    private static HashMap tags;
    private String className;
    private String packageName;
    private String packagePath;
    private String appName;

    public static String getValue(String key) {
        if (tags == null) {
            return null;
        }
        Object result = tags.get(key);
        if (result == null) {
            return null;
        }
        return (String)result;
    }

    public JadFileParser(String fileName) {
        if (tags == null) {
            tags = new HashMap();
        } else {
            tags.clear();
        }
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                System.out.println("Error:jadFileParser: file not exist, file=" + fileName);
                return;
            }
            this.packagePath = file.getParent();
            FileReader fileReader = new FileReader(file);
            LineNumberReader reader = new LineNumberReader(fileReader);
            this.parseData(reader);
            reader.close();
        }
        catch (Exception e2) {
            System.out.println("Error:JadFileParser:" + e2);
            e2.printStackTrace();
        }
    }

    public JadFileParser(InputStream ins) {
        if (tags == null) {
            tags = new HashMap();
        } else {
            tags.clear();
        }
        try {
            InputStreamReader inputReader = new InputStreamReader(ins);
            LineNumberReader reader = new LineNumberReader(inputReader);
            this.parseData(reader);
        }
        catch (Exception e2) {
            System.out.println("Error:JadFileParser:" + e2);
            e2.printStackTrace();
        }
    }

    private void parseData(LineNumberReader reader) throws Exception {
        String line = ".";
        while (line != null) {
            line = reader.readLine();
            if (line == null || line.length() <= 0) continue;
            this.parseLine(line);
        }
    }

    private void parseLine(String line) {
        String tagName = JadFileParser.getJadLineValue(line, 0);
        String tagValue = JadFileParser.getJadLineValue(line, 1);
        String tagValueFull = JadFileParser.getJadLineValue(line, -1);
        tagValue = JadFileParser.cleanValue(tagValue);
        if (line.startsWith(TAG_JAR)) {
            this.packageName = JadFileParser.getJadLineValue(line, 1);
            this.packageName = JadFileParser.cleanValue(this.packageName);
        } else if (line.startsWith(TAG_CLASS)) {
            this.className = JadFileParser.getJadLineValue(line, 3);
            this.className = JadFileParser.cleanValue(this.className);
        } else if (line.startsWith(TAG_NAME)) {
            this.appName = JadFileParser.getJadLineValue(line, 1);
            this.appName = JadFileParser.cleanValue(this.appName);
        }
        tags.put(tagName, tagValueFull);
    }

    public static String getLineValue(String line, int index) {
        StringTokenizer tokenizer = new StringTokenizer(line, ":,=");
        int size = tokenizer.countTokens();
        int i2 = 0;
        while (i2 < size) {
            String result = tokenizer.nextToken();
            if (i2 == index) {
                return result;
            }
            ++i2;
        }
        return null;
    }

    public static String getJadLineValue(String line, int index) {
        int begin = 0;
        int end = 0;
        if (index < 0) {
            end = line.length();
            begin = line.indexOf(58);
            if (begin < 0) {
                begin = line.indexOf(61);
            }
            if (begin < 0) {
                return line;
            }
            String result = JadFileParser.cleanValue(line.substring(begin + 1, end));
            return result;
        }
        if (index == 0) {
            end = line.indexOf(58);
            if (end < 0) {
                end = line.indexOf(61);
            }
            if (end < 0) {
                return line;
            }
            String result = JadFileParser.cleanValue(line.substring(begin, end));
            return result;
        }
        int i2 = 0;
        while (i2 < index) {
            if (i2 == 0) {
                int pos = line.indexOf(58, begin);
                if (pos < 0) {
                    begin = line.indexOf(61);
                }
                begin = pos;
            } else {
                begin = line.indexOf(44, begin);
            }
            if (begin < 0) {
                return null;
            }
            if ((end = line.indexOf(44, ++begin)) < 0) {
                end = line.length();
            }
            ++i2;
        }
        String result = JadFileParser.cleanValue(line.substring(begin, end));
        return result;
    }

    public static String cleanValue(String line) {
        if (line == null) {
            return null;
        }
        int size = line.length();
        int i2 = 0;
        while (i2 < size && line.charAt(i2) == ' ') {
            ++i2;
        }
        if (i2 == 0) {
            return line;
        }
        return line.substring(i2, size - i2 + 1);
    }

    public String getClassName() {
        if (this.className == null) {
            System.out.println("Error: incomplete JAD file. " + TAG_CLASS + " is missing or currupted!");
        }
        return this.className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackageName(String name) {
        if (name == null) {
            return null;
        }
        int index = name.lastIndexOf(47);
        if (index < 0) {
            index = name.lastIndexOf(92);
        }
        if (index < 0) {
            return name;
        }
        return name.substring(index + 1);
    }

    public String getPackagePath() {
        return this.packagePath;
    }

    public String getApplicationName() {
        return this.appName;
    }
}

