/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import ole.pstros.MainApp;
import ole.pstros.utils.BaseClassLoader;

public class JarClassLoader
extends BaseClassLoader {
    private static JarClassLoader instance;
    private JarFile jarFile;
    private boolean loading;

    public static JarClassLoader getInstance(String jarFileName) {
        if (instance == null) {
            instance = new JarClassLoader(jarFileName);
        } else {
            instance.setJarFilename(jarFileName);
        }
        return instance;
    }

    public JarClassLoader(ClassLoader masterCl) {
        super(masterCl);
        instance = this;
    }

    public JarClassLoader(String jarFileName) {
        this.setJarFilename(jarFileName);
    }

    public void setJarFilename(String jarFileName) {
        try {
            this.jarFile = new JarFile(jarFileName);
        }
        catch (Exception e2) {
            System.out.println("Error:" + this.getClass().toString() + " : " + e2);
            System.out.println(" file=" + jarFileName);
        }
    }

    protected byte[] loadData(String name) {
        if (this.jarFile == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        ZipEntry entry = this.jarFile.getEntry(name);
        try {
            InputStream stream = this.jarFile.getInputStream(entry);
            int size = (int)entry.getSize();
            int offset = 0;
            int red = 0;
            byte[] result = new byte[size];
            while (size > 0) {
                red = stream.read(result, offset, size);
                size -= red;
                offset += red;
            }
            if (MainApp.verbose) {
                System.out.println("loadData name= " + name);
            }
            return result;
        }
        catch (Exception e2) {
            if (MainApp.verbose) {
                System.out.println("Warning:" + this.getClass().toString() + " : " + e2);
                System.out.println("  loadData: name=" + name);
            }
            return null;
        }
    }

    public URL getResource(String name) {
        if (MainApp.verbose) {
            System.out.println("Pstros JarClassLoader: getResource called name=" + name);
        }
        return this.getUrl(name);
    }

    public static URL getSystemResource(String name) {
        if (MainApp.verbose) {
            System.out.println("Pstros JarClassLoader: getSystemResource called name=" + name);
        }
        if (instance == null) {
            return null;
        }
        return instance.getUrl(name);
    }

    public static InputStream getSystemResourceAsStream(String name) {
        if (MainApp.verbose) {
            System.out.println("Pstros JarClassLoader: getSystemResourceAsStream called name=" + name);
        }
        return null;
    }

    protected URL findResource(String name) {
        if (MainApp.verbose) {
            System.out.println("Pstros JarClassLoader: findResource called name=" + name);
        }
        return this.getUrl(name);
    }

    private URL getUrl(String name) {
        if (this.jarFile == null) {
            return null;
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        ZipEntry entry = this.jarFile.getEntry(name);
        try {
            InputStream stream = this.jarFile.getInputStream(entry);
        }
        catch (Exception e2) {
            System.out.println("Error: + entry=" + entry + " name=" + name);
            e2.printStackTrace();
            return null;
        }
        URL url = null;
        try {
            url = new URL("pstros:///" + name);
        }
        catch (Exception e3) {
            e3.printStackTrace();
        }
        if (MainApp.verbose) {
            System.out.println("url=" + url);
        }
        return url;
    }
}

