/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.ScrollPaneAdjustable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import ole.pstros.ConfigData;
import ole.pstros.utils.ListItem;

public class ListViewer
extends Canvas
implements WindowListener,
MouseListener,
MouseMotionListener,
AdjustmentListener {
    private static final String[] COLUMN_TITLE = new String[]{""};
    private static final int[] COLUMN_WIDTH = new int[]{220};
    private static Color COLOR_WHITE = new Color(0xFFFFFF);
    private static Color COLOR_BLACK = new Color(0);
    private static Color COLOR_RED = new Color(0xFF0000);
    public static final Color COLOR_GRAY = new Color(0x9F9F9F);
    public static final Color COLOR_LIGHT_GRAY = new Color(0xD0D0D0);
    private ListItem[] items;
    private int itemCount;
    private Frame parent;
    private Container container;
    private ScrollPaneAdjustable vScroll;
    private int mouseX;
    private int mouseY;
    private int infoX;
    private int infoY;
    private int infoH;
    private int offsetY;
    private int fontAscent;
    private int fontDescent;
    private ListItem selectedItem;
    private String[] columnTitle;
    private int[] columnWidth;
    private Dimension itemsChange;
    private int columnMove = -1;
    private int columnMoveX;

    public ListViewer(Frame parent, Container container) {
        this.setBackground(COLOR_GRAY);
        this.parent = parent;
        this.container = container;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.infoY = -1;
        this.columnTitle = COLUMN_TITLE;
        this.columnWidth = COLUMN_WIDTH;
    }

    public void setItems(ListItem[] newItems, int size) {
        this.items = newItems;
        this.itemCount = size;
    }

    public void notifyProfileChange() {
        this.itemsChange = this.getSize();
    }

    public void setColumnInfo(String[] title, int[] width) {
        this.columnTitle = title;
        this.columnWidth = width;
    }

    public void paint(Graphics g2) {
        String value;
        int size = this.itemCount;
        int h2 = this.getFontHeight();
        int w = this.getWidth() + 16;
        int posY = 2;
        int columnCount = 1;
        if (this.columnWidth != null) {
            columnCount = this.columnWidth.length;
        }
        if (this.infoH < 1) {
            FontMetrics fm = g2.getFontMetrics();
            this.infoH = fm.getHeight() + 5;
            this.fontAscent = fm.getAscent() + 2;
            this.fontDescent = fm.getDescent();
        }
        g2.setColor(COLOR_LIGHT_GRAY);
        g2.fillRect(0, posY - 1, w, h2 + 1);
        g2.setColor(COLOR_BLACK);
        int posX = 5;
        int j2 = 0;
        while (j2 < columnCount) {
            value = this.columnTitle[j2];
            if (value != null) {
                g2.drawString(value, posX, posY + h2 - this.fontDescent);
                g2.drawLine(posX += this.columnWidth[j2] - 4, posY - 1, posX, posY + h2);
                posX += 4;
            }
            ++j2;
        }
        g2.setColor(COLOR_BLACK);
        g2.drawLine(2, posY += h2, w - 20, posY);
        ++posY;
        int i2 = 0;
        while (i2 < size) {
            ListItem item = this.items[i2];
            g2.setColor(COLOR_WHITE);
            g2.setClip(0, posY, w, h2);
            g2.fillRect(0, posY, w, h2);
            g2.setColor(COLOR_BLACK);
            posX = 5;
            int j3 = 0;
            while (j3 < columnCount) {
                int columnW = this.columnWidth[j3];
                value = item.getColumnValue(j3);
                if (value != null) {
                    g2.setClip(posX, posY, columnW - 5, posY + h2);
                    g2.drawString(value, posX, posY + h2 - this.fontDescent);
                    g2.setClip(posX += columnW - 4, posY - 1, 2, posY + h2);
                    g2.drawLine(posX, posY - 1, posX, posY + h2);
                    posX += 4;
                }
                ++j3;
            }
            g2.setColor(COLOR_BLACK);
            g2.setClip(0, posY += h2, w - 20, 2);
            g2.drawLine(2, posY, w - 20, posY);
            ++posY;
            ++i2;
        }
        if (this.itemsChange != null) {
            if (this.itemsChange.height > posY) {
                g2.setColor(COLOR_GRAY);
                g2.setClip(0, posY, this.getWidth(), this.itemsChange.height - posY);
                g2.fillRect(0, posY, this.getWidth(), this.itemsChange.height - posY);
            }
            this.itemsChange = null;
        }
        if (this.columnMove > -1) {
            g2.setColor(COLOR_RED);
            g2.setClip(this.columnMoveX - 1, 0, 3, h2);
            g2.drawLine(this.columnMoveX, 0, this.columnMoveX, h2);
        }
    }

    public void repaintItems() {
        if (this.items == null) {
            return;
        }
        if (this.itemsChange != null) {
            this.repaint();
            return;
        }
        int h2 = this.getFontHeight();
        int size = this.items.length;
        int shiftY = this.columnTitle != null ? h2 : 0;
        int w = this.getWidth();
        int i2 = 0;
        while (i2 < size) {
            ListItem item = this.items[i2];
            if (item.isChanged()) {
                int posY = i2 * h2 + shiftY;
                this.repaint(0, posY, w, h2 + 2);
            }
            ++i2;
        }
    }

    public void setVerticalScroll(ScrollPaneAdjustable spa) {
        this.vScroll = spa;
        this.vScroll.addAdjustmentListener(this);
    }

    public Dimension getSize() {
        if (this.items == null) {
            return super.getSize();
        }
        int count = this.itemCount;
        int width = 260;
        if (this.columnTitle != null) {
            ++count;
        }
        if (this.columnWidth != null) {
            width = 0;
            int i2 = 0;
            while (i2 < this.columnWidth.length) {
                width += this.columnWidth[i2];
                ++i2;
            }
        }
        return new Dimension(width, (this.getFontHeight() + 2) * count);
    }

    private ListItem getItemAt(int y) {
        int index;
        if (this.items == null) {
            return null;
        }
        int fontHeight = this.getFontHeight() + 2;
        if (this.columnTitle != null) {
            y -= fontHeight;
        }
        if ((index = y / fontHeight) >= this.itemCount || y < 0) {
            return null;
        }
        return this.items[index];
    }

    private int getFontHeight() {
        Font font = this.getFont();
        return font.getSize() + 4;
    }

    public void windowActivated(WindowEvent e2) {
        this.requestFocus();
    }

    public void windowClosed(WindowEvent e2) {
    }

    public void windowClosing(WindowEvent e2) {
        this.storeBounds();
        this.items = null;
        this.itemCount = 0;
        this.selectedItem = null;
        this.parent.dispose();
    }

    public void storeBounds() {
        ConfigData.classMonitorBounds = this.parent.getBounds();
    }

    public void windowDeactivated(WindowEvent e2) {
    }

    public void windowDeiconified(WindowEvent e2) {
    }

    public void windowIconified(WindowEvent e2) {
    }

    public void windowOpened(WindowEvent e2) {
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void mouseEntered(MouseEvent e2) {
    }

    public void mouseExited(MouseEvent e2) {
    }

    public void mousePressed(MouseEvent e2) {
        this.mouseY = e2.getY();
        this.mouseX = e2.getX();
        int h2 = this.getFontHeight();
        if (this.mouseY < h2) {
            int found = -1;
            int posX = 0;
            int i2 = 0;
            while (i2 < this.columnWidth.length) {
                if (this.mouseX > (posX += this.columnWidth[i2]) - 2 && this.mouseX < posX + 4) {
                    found = i2;
                    break;
                }
                ++i2;
            }
            if (found > -1) {
                this.columnMove = found;
                this.columnMoveX = posX;
                this.repaint(0, 0, this.getWidth(), h2);
            }
            return;
        }
        this.selectedItem = this.getItemAt(this.mouseY);
        if (this.selectedItem == null) {
            return;
        }
        this.infoX = this.mouseX;
        this.infoY = this.mouseY - this.infoH;
        if (this.infoY < 0) {
            this.infoY = 0;
        }
        this.repaint(this.infoX, this.infoY, 128, this.infoH);
    }

    public void mouseReleased(MouseEvent e2) {
        this.infoY = -1;
        if (this.columnMove > -1) {
            int h2 = this.getFontHeight();
            if (e2.getY() < h2) {
                int posX = 0;
                int i2 = 0;
                while (i2 < this.columnMove + 1) {
                    posX += this.columnWidth[i2];
                    ++i2;
                }
                int diff = this.columnMoveX - posX;
                int n2 = this.columnMove;
                this.columnWidth[n2] = this.columnWidth[n2] + diff;
            }
            this.columnMove = -1;
        }
        this.repaint();
    }

    public void mouseDragged(MouseEvent e2) {
        if (this.columnMove > -1) {
            this.columnMoveX = e2.getX();
            this.repaint(0, 0, this.getWidth(), 20);
        }
    }

    public void mouseMoved(MouseEvent e2) {
    }

    public void adjustmentValueChanged(AdjustmentEvent e2) {
        this.offsetY = e2.getValue();
    }
}

