/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.InputStream;
import ole.pstros.utils.DecoderListener;
import ole.pstros.utils.Orv2Tga;

public class OrvPlayer
extends Canvas
implements DecoderListener,
WindowListener {
    private Frame playerFrame;
    private InputStream is;
    private BufferedImage bi;
    private int imageWidth;
    private int imageHeight;
    private int[] RGBdata;
    private int frameWidth;
    private int frameHeight;
    private int frameMillis = 40;

    public OrvPlayer(String name, int w, int h2) {
        this.frameWidth = w;
        this.frameHeight = h2;
        try {
            this.is = name != null ? new FileInputStream(name) : "".getClass().getResourceAsStream("/capt.orv");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void open() {
        this.createFrame();
        Orv2Tga.process(this.is, null, this);
    }

    public void update(Graphics g2) {
        if (this.bi != null) {
            g2.drawImage(this.bi, 0, 0, null);
        } else {
            g2.setColor(Color.GRAY);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public void setFrameDelay(int millis) {
    }

    public int decodeFrame(byte[] rgb, int w, int h2) {
        if (w != this.imageWidth || h2 != this.imageHeight) {
            this.bi = new BufferedImage(w, h2, 1);
            this.RGBdata = new int[w * h2];
            this.imageWidth = w;
            this.imageHeight = h2;
        }
        this.convertData(rgb);
        this.bi.setRGB(0, 0, w, h2, this.RGBdata, 0, w);
        this.repaint();
        return this.frameMillis;
    }

    private void convertData(byte[] rgb) {
        int max = rgb.length / 3;
        if (max > this.RGBdata.length) {
            max = this.RGBdata.length;
        }
        int offset = 0;
        int i2 = 0;
        while (i2 < max) {
            int pixel = rgb[offset++] & 0xFF;
            pixel |= (rgb[offset++] & 0xFF) << 8;
            this.RGBdata[i2] = pixel |= (rgb[offset++] & 0xFF) << 16;
            ++i2;
        }
    }

    private void createFrame() {
        this.playerFrame = new Frame();
        this.playerFrame.setTitle("Pstros ORV player");
        this.playerFrame.addWindowListener(this);
        this.playerFrame.add(this);
        this.playerFrame.setVisible(true);
        Insets insets = this.playerFrame.getInsets();
        this.frameWidth += insets.right + insets.left;
        this.frameHeight += insets.bottom + insets.top;
        this.playerFrame.setSize(this.frameWidth, this.frameHeight);
        this.playerFrame.doLayout();
    }

    public void windowActivated(WindowEvent e2) {
    }

    public void windowClosed(WindowEvent e2) {
    }

    public void windowClosing(WindowEvent e2) {
        Orv2Tga.decode = false;
        this.playerFrame.setVisible(false);
        this.playerFrame.dispose();
        this.playerFrame = null;
    }

    public void windowDeactivated(WindowEvent e2) {
    }

    public void windowDeiconified(WindowEvent e2) {
    }

    public void windowIconified(WindowEvent e2) {
    }

    public void windowOpened(WindowEvent e2) {
    }
}

