/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import javax.microedition.lcdui.Display;
import ole.pstros.ConfigData;
import ole.pstros.monitor.ClassManager;
import ole.pstros.utils.ConfigLoader;
import ole.pstros.utils.ParamWriter;

public class ParamReader {
    private static String lastMonitorProfile;
    private static ClassManager cm;

    public static final void readParams() {
        if (ConfigData.readOnly) {
            return;
        }
        String line = ".";
        try {
            File file = new File(ParamWriter.getDataFilename());
            if (!file.exists()) {
                return;
            }
            FileReader fileReader = new FileReader(file);
            LineNumberReader reader = new LineNumberReader(fileReader);
            while (line != null) {
                line = reader.readLine();
                if (line == null) continue;
                ParamReader.parseLine(line);
            }
            reader.close();
            fileReader.close();
        }
        catch (Exception e2) {
            System.out.println("Error:ConfigLoader:" + e2);
            e2.printStackTrace();
        }
    }

    private static final void parseLine(String line) {
        if (line.startsWith("window.positionX")) {
            ConfigData.windowPositionX = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("window.positionY")) {
            ConfigData.windowPositionY = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keySoftLeft")) {
            Display.keySoftLeft = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.config")) {
            int config = ConfigLoader.getIntValue(line);
            ConfigData.controlConfig = config > 0;
        } else if (line.startsWith("control.keySoftRight") || line.startsWith("control.keySoftRifgt")) {
            Display.keySoftRight = ConfigLoader.getIntValue(line);
            Display.keySoftRight = 27;
        } else if (line.startsWith("control.keySoftCenter")) {
            Display.keySoftCenter = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyLeft")) {
            Display.keyLeft = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyRight")) {
            Display.keyRight = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyUp")) {
            Display.keyUp = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyDown")) {
            Display.keyDown = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyFire")) {
            Display.keyFire = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyNum0")) {
            Display.keyNum0 = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyNum1")) {
            Display.keyNum1 = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyNum2")) {
            Display.keyNum2 = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyNum3")) {
            Display.keyNum3 = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyNum4")) {
            Display.keyNum4 = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyNum5")) {
            Display.keyNum5 = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyNum6")) {
            Display.keyNum6 = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyNum7")) {
            Display.keyNum7 = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyNum8")) {
            Display.keyNum8 = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyNum9")) {
            Display.keyNum9 = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyStar")) {
            Display.keyStar = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyCross")) {
            Display.keyCross = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyScreenShot")) {
            Display.keyScreenShot = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyCaptureVideo")) {
            Display.keyCaptureVideo = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyShowHideNotify")) {
            Display.keyShowHideNotify = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("control.keyResizeScreen")) {
            Display.keyRotate = ConfigLoader.getIntValue(line);
        } else if (line.startsWith("monitor.enable")) {
            ConfigData.classMonitor = ConfigLoader.getIntValue(line) != 0;
            cm = ClassManager.getInstance();
        } else if (line.startsWith("monitor.profile")) {
            lastMonitorProfile = ConfigLoader.getStringValue(line);
        } else if (line.startsWith("monitor.variable") && cm != null) {
            cm.addVariable(ConfigLoader.getStringValue(line), lastMonitorProfile);
        } else if (line.startsWith("monitor.positionX")) {
            ConfigData.classMonitorBounds = ParamReader.setBounds(ConfigData.classMonitorBounds, ConfigLoader.getIntValue(line), -1, -1, -1);
        } else if (line.startsWith("monitor.positionY")) {
            ConfigData.classMonitorBounds = ParamReader.setBounds(ConfigData.classMonitorBounds, -1, ConfigLoader.getIntValue(line), -1, -1);
        } else if (line.startsWith("monitor.width")) {
            ConfigData.classMonitorBounds = ParamReader.setBounds(ConfigData.classMonitorBounds, -1, -1, ConfigLoader.getIntValue(line), -1);
        } else if (line.startsWith("monitor.height")) {
            ConfigData.classMonitorBounds = ParamReader.setBounds(ConfigData.classMonitorBounds, -1, -1, -1, ConfigLoader.getIntValue(line));
        } else if (line.startsWith("imageViewer.positionX")) {
            ConfigData.imageViewerBounds = ParamReader.setBounds(ConfigData.imageViewerBounds, ConfigLoader.getIntValue(line), -1, -1, -1);
        } else if (line.startsWith("imageViewer.positionY")) {
            ConfigData.imageViewerBounds = ParamReader.setBounds(ConfigData.imageViewerBounds, -1, ConfigLoader.getIntValue(line), -1, -1);
        } else if (line.startsWith("imageViewer.width")) {
            ConfigData.imageViewerBounds = ParamReader.setBounds(ConfigData.imageViewerBounds, -1, -1, ConfigLoader.getIntValue(line), -1);
        } else if (line.startsWith("imageViewer.height")) {
            ConfigData.imageViewerBounds = ParamReader.setBounds(ConfigData.imageViewerBounds, -1, -1, -1, ConfigLoader.getIntValue(line));
        } else if (line.startsWith("zoomViewer.size")) {
            ConfigData.zoomSize = ConfigLoader.getIntValue(line);
        }
    }

    private static Rectangle setBounds(Rectangle result, int x, int y, int w, int h2) {
        if (result == null) {
            result = new Rectangle();
        }
        if (x > -1) {
            result.x = x;
        }
        if (y > -1) {
            result.y = y;
        }
        if (w > -1) {
            result.width = w;
        }
        if (h2 > -1) {
            result.height = h2;
        }
        return result;
    }
}

