/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import ole.pstros.MainApp;
import ole.pstros.utils.ImaConvertor;
import ole.pstros.utils.WaveConvertor;

public class SoundConvertor {
    public static final int FORMAT_UNKNOWN = 0;
    public static final int FORMAT_WAVE_PCM = 1;
    public static final int FORMAT_WAVE_IMA_ADPCM = 17;
    private static byte[] RIFF_HEADER;
    private static int[] soundParams;

    static {
        byte[] byArray = new byte[43];
        byArray[0] = 82;
        byArray[1] = 73;
        byArray[2] = 70;
        byArray[3] = 70;
        byArray[8] = 87;
        byArray[9] = 65;
        byArray[10] = 86;
        byArray[11] = 69;
        byArray[12] = 102;
        byArray[13] = 109;
        byArray[14] = 116;
        byArray[15] = 32;
        byArray[16] = 16;
        byArray[20] = 1;
        byArray[22] = 1;
        byArray[24] = 64;
        byArray[25] = 31;
        byArray[29] = 125;
        byArray[32] = 2;
        byArray[34] = 16;
        byArray[36] = 100;
        byArray[37] = 97;
        byArray[38] = 116;
        byArray[39] = 97;
        RIFF_HEADER = byArray;
        soundParams = new int[3];
    }

    public static InputStream convertData(InputStream stream) {
        ByteArrayInputStream bs = null;
        DataInputStream dis = new DataInputStream(stream);
        try {
            int size = dis.available();
            byte[] data = new byte[size];
            dis.readFully(data);
            dis.close();
            int format = SoundConvertor.getFormat(data);
            SoundConvertor.initSoundParams();
            switch (format) {
                case 0: {
                    if (!MainApp.verbose) break;
                    System.out.println("Unknown format!");
                    break;
                }
                case 1: {
                    if (!MainApp.verbose) break;
                    System.out.println("PCM format found");
                    break;
                }
                case 17: {
                    if (MainApp.verbose) {
                        System.out.println("IMA_ADPCM format found");
                    }
                    WaveConvertor conv = ImaConvertor.getInstance();
                    data = conv.convert(data, soundParams);
                }
            }
            if (soundParams[0] > 0) {
                data = SoundConvertor.createRiffData(data, soundParams);
            }
            bs = new ByteArrayInputStream(data);
            return bs;
        }
        catch (Exception e2) {
            System.out.println("SoundConvertor:" + e2);
            e2.printStackTrace();
            return null;
        }
    }

    private static int getFormat(byte[] data) {
        int result = 0;
        if (data[0] == 82 && data[1] == 73 && data[2] == 70 && data[3] == 70 && data[8] == 87 && data[9] == 65 && data[10] == 86 && data[11] == 69 && data[12] == 102 && data[13] == 109 && data[14] == 116 && data[15] == 32) {
            if (data[20] == 1 && data[21] == 0) {
                result = 1;
            } else if (data[20] == 17 && data[21] == 0) {
                result = 17;
            } else {
                System.out.println("Sound convertor unknown WAV format: " + Integer.toHexString(data[20]) + "/" + Integer.toHexString(data[21]));
            }
        }
        return result;
    }

    private static void initSoundParams() {
        int i2 = 0;
        while (i2 < 3) {
            SoundConvertor.soundParams[i2] = -1;
            ++i2;
        }
    }

    private static byte[] createRiffData(byte[] srcData, int[] params) {
        int channels = params[0];
        int freq = params[1];
        int bytesPerChannel = params[2];
        int bytesPerSec = channels * bytesPerChannel * freq;
        int size = RIFF_HEADER.length + srcData.length;
        byte[] dstBuffer = new byte[size];
        System.arraycopy(RIFF_HEADER, 0, dstBuffer, 0, RIFF_HEADER.length);
        System.arraycopy(srcData, 0, dstBuffer, RIFF_HEADER.length, srcData.length);
        SoundConvertor.write2b(dstBuffer, 22, channels);
        SoundConvertor.write4b(dstBuffer, 24, freq);
        SoundConvertor.write4b(dstBuffer, 28, bytesPerSec);
        SoundConvertor.write2b(dstBuffer, 32, bytesPerChannel * channels);
        SoundConvertor.write2b(dstBuffer, 34, bytesPerChannel * 8);
        SoundConvertor.write4b(dstBuffer, 40, srcData.length);
        SoundConvertor.write4b(dstBuffer, 4, dstBuffer.length - 8);
        return dstBuffer;
    }

    private static void write4b(byte[] data, int offset, int value) {
        data[offset] = (byte)(value & 0xFF);
        data[offset + 1] = (byte)(value >>> 8 & 0xFF);
        data[offset + 2] = (byte)(value >>> 16 & 0xFF);
        data[offset + 3] = (byte)(value >>> 24 & 0xFF);
    }

    private static void write2b(byte[] data, int offset, int value) {
        data[offset] = (byte)(value & 0xFF);
        data[offset + 1] = (byte)(value >>> 8 & 0xFF);
    }
}

