/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import ole.pstros.ConfigData;
import ole.pstros.utils.TgaWriter;

public class StreamSaver {
    public static final byte ORV_VERSION = 1;
    private static String fileName = "capture.orv";
    private static byte[] header = new byte[8];
    public static final int TYPE_ORV = 0;
    public static final int TYPE_TGA = 1;
    private static int type = 1;
    private static int imageIndex;
    private static FileOutputStream stream;
    public static byte[] buf;
    public static int[] data;
    public static int[] data2;
    private static boolean dataSwitch;
    private static int[] scrollResult;
    private static long frameTime;
    private static byte[] frameTimeBuff;

    static {
        buf = new byte[307200];
        data = new int[76832];
        scrollResult = new int[2];
        frameTime = -1L;
        frameTimeBuff = new byte[4];
    }

    public static void setFileName(String name) {
        fileName = name;
    }

    public static void init(int width, int height, int streamType) throws Exception {
        int dataSize = width * height * 3;
        type = streamType;
        if (type == 0) {
            if (data2 == null) {
                data2 = new int[data.length];
            }
            StreamSaver.setHeader(width, height);
            stream = new FileOutputStream(fileName);
            stream.write(header);
        } else {
            File file = new File("capt");
            if (!file.exists()) {
                file.mkdir();
            } else if (!file.isDirectory()) {
                throw new Exception("file 'capt' already exists, can't capture!");
            }
            imageIndex = 0;
        }
    }

    public static void saveImageData(BufferedImage image, int w, int h2, int y) {
        if (image == null) {
            return;
        }
        try {
            int[] RGBdata = data;
            int[] OLDdata = data2;
            if (type == 0) {
                if (dataSwitch) {
                    RGBdata = data2;
                    OLDdata = data;
                }
                dataSwitch = !dataSwitch;
            }
            image.getRGB(0, y, w, h2, RGBdata, 0, w);
            if (type == 0) {
                int dataSize = StreamSaver.fillDiffBuffer(RGBdata, OLDdata, w, h2);
                long now = System.currentTimeMillis();
                if (frameTime < 0L) {
                    frameTime = now;
                }
                int diffTime = (int)(now - frameTime);
                frameTime = now;
                StreamSaver.frameTimeBuff[0] = (byte)((diffTime & 0xFF000000) >> 24);
                StreamSaver.frameTimeBuff[1] = (byte)((diffTime & 0xFF0000) >> 16);
                StreamSaver.frameTimeBuff[2] = (byte)((diffTime & 0xFF00) >> 8);
                StreamSaver.frameTimeBuff[3] = (byte)(diffTime & 0xFF);
                stream.write(frameTimeBuff, 0, 4);
                stream.write(buf, 0, dataSize);
            } else {
                int dataSize = StreamSaver.fillFullBuffer(RGBdata, w, h2);
                TgaWriter.saveImageData("capt/image", buf, 0, dataSize, w, h2, imageIndex++);
            }
        }
        catch (Exception e2) {
            System.out.println("Error: StreamSaver: " + e2);
        }
    }

    private static int fillFullBuffer(int[] RGBdata, int w, int h2) {
        int size = w * h2;
        int dataSize = size * 3;
        int offset = 0;
        int i2 = 0;
        while (i2 < size) {
            int pixel = RGBdata[i2];
            StreamSaver.buf[offset++] = (byte)(pixel & 0xFF);
            StreamSaver.buf[offset++] = (byte)(pixel >> 8 & 0xFF);
            StreamSaver.buf[offset++] = (byte)(pixel >> 16 & 0xFF);
            ++i2;
        }
        return dataSize;
    }

    private static int fillDiffBuffer(int[] RGBdata, int[] OLDdata, int w, int h2) {
        int blockCounter = 0;
        int size = w * h2;
        int offset = 4;
        int sizeOffset = 8;
        boolean storeSize = false;
        int blockSize = 0;
        int scroll = StreamSaver.detectScroll(RGBdata, OLDdata, w, h2);
        StreamSaver.buf[0] = (byte)scrollResult[0];
        StreamSaver.buf[1] = (byte)scrollResult[1];
        int i2 = 0;
        while (i2 < size) {
            int pixel1 = RGBdata[i2];
            int pixelIndex = i2 + scroll;
            int pixel2 = pixelIndex < 0 || pixelIndex >= size ? 0 : OLDdata[pixelIndex];
            if (pixel1 == pixel2) {
                if (storeSize) {
                    StreamSaver.writeInt(blockSize, sizeOffset);
                    storeSize = false;
                    blockSize = 0;
                }
            } else {
                if (!storeSize) {
                    sizeOffset = offset = StreamSaver.writeInt(i2, offset);
                    offset += 4;
                    storeSize = true;
                    ++blockCounter;
                }
                StreamSaver.buf[offset++] = (byte)(pixel1 & 0xFF);
                StreamSaver.buf[offset++] = (byte)(pixel1 >> 8 & 0xFF);
                StreamSaver.buf[offset++] = (byte)(pixel1 >> 16 & 0xFF);
                ++blockSize;
            }
            ++i2;
        }
        if (storeSize) {
            StreamSaver.writeInt(blockSize, sizeOffset);
        }
        StreamSaver.writeShort(blockCounter, 2);
        return offset;
    }

    private static int writeInt(int number, int offset) {
        StreamSaver.buf[offset++] = (byte)(number >> 24 & 0xFF);
        StreamSaver.buf[offset++] = (byte)(number >> 16 & 0xFF);
        StreamSaver.buf[offset++] = (byte)(number >> 8 & 0xFF);
        StreamSaver.buf[offset++] = (byte)(number & 0xFF);
        return offset;
    }

    private static int writeShort(int number, int offset) {
        StreamSaver.buf[offset++] = (byte)(number >> 8 & 0xFF);
        StreamSaver.buf[offset++] = (byte)(number & 0xFF);
        return offset;
    }

    private static int detectScroll(int[] cData, int[] oData, int w, int h2) {
        int yStep = (h2 - 16) / ConfigData.captureMotionPrecision;
        int xStep = (w - 16) / ConfigData.captureMotionPrecision;
        int yMax = 8 + yStep * ConfigData.captureMotionPrecision;
        int xMax = 8 + xStep * ConfigData.captureMotionPrecision;
        int offset = 0;
        boolean resultIndex = false;
        int maxRes = -1;
        int maxIdx = -1;
        int scrollX = 0;
        int scrollY = 0;
        int i2 = 0;
        while (i2 < 81) {
            scrollX = i2 % 9;
            scrollY = i2 / 9;
            if (scrollX > 4) {
                scrollX = -scrollX + 4;
            }
            if (scrollY > 4) {
                scrollY = -scrollY + 4;
            }
            offset = scrollY * w + scrollX;
            int res = 0;
            int y = 8;
            while (y < yMax) {
                int x = 8;
                while (x < xMax) {
                    int pixelOffset = y * w + x;
                    boolean scrollTest = cData[pixelOffset] == oData[pixelOffset + offset];
                    res += scrollTest ? 1 : 0;
                    x += xStep;
                }
                y += yStep;
            }
            if (res > maxRes) {
                maxRes = res;
                maxIdx = i2;
                StreamSaver.scrollResult[0] = scrollX;
                StreamSaver.scrollResult[1] = scrollY;
            }
            ++i2;
        }
        return scrollResult[1] * w + scrollResult[0];
    }

    public static void close() {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception e2) {
                System.out.println("Error: StreamSaver: " + e2);
            }
            stream = null;
        }
    }

    private static void setHeader(int width, int height) {
        StreamSaver.header[0] = 79;
        StreamSaver.header[1] = 82;
        StreamSaver.header[2] = 86;
        StreamSaver.header[3] = 1;
        StreamSaver.header[4] = (byte)(width & 0xFF);
        StreamSaver.header[5] = (byte)((width & 0xFF00) >> 8);
        StreamSaver.header[6] = (byte)(height & 0xFF);
        StreamSaver.header[7] = (byte)((height & 0xFF00) >> 8);
    }
}

