/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.awt.image.BufferedImage;
import java.io.FileOutputStream;
import ole.pstros.utils.StreamSaver;

public class TgaWriter {
    public static final byte FORMAT_RGBA8888 = 32;
    public static final byte FORMAT_RGB888 = 24;
    private static byte format = (byte)24;
    private static byte[] tgaHeader;

    static {
        byte[] byArray = new byte[18];
        byArray[2] = 2;
        byArray[16] = 24;
        byArray[17] = 32;
        tgaHeader = byArray;
    }

    public static void setFormat(byte f2) {
        format = f2;
    }

    public static String saveImageTransparent(String name, BufferedImage image, int w, int h2, int y, int index) {
        if (image == null) {
            return null;
        }
        String fileName = null;
        try {
            TgaWriter.setFormat((byte)32);
            image.getRGB(0, y, w, h2, StreamSaver.data, 0, w);
            int size = w * h2;
            int offset = 0;
            int i2 = 0;
            while (i2 < size) {
                int pixel = StreamSaver.data[i2];
                StreamSaver.buf[offset++] = (byte)(pixel & 0xFF);
                StreamSaver.buf[offset++] = (byte)(pixel >> 8 & 0xFF);
                StreamSaver.buf[offset++] = (byte)(pixel >> 16 & 0xFF);
                StreamSaver.buf[offset++] = (byte)(pixel >> 24 & 0xFF);
                ++i2;
            }
            fileName = TgaWriter.saveImageData(name, StreamSaver.buf, 0, offset, w, h2, index);
        }
        catch (Exception e2) {
            System.out.println("Error: StreamSaver: " + e2);
        }
        return fileName;
    }

    public static String saveImage(String name, BufferedImage image, int w, int h2, int y, int index) {
        if (image == null) {
            return null;
        }
        String fileName = null;
        try {
            TgaWriter.setFormat((byte)24);
            image.getRGB(0, y, w, h2, StreamSaver.data, 0, w);
            int size = w * h2;
            int offset = 0;
            int i2 = 0;
            while (i2 < size) {
                int pixel = StreamSaver.data[i2];
                StreamSaver.buf[offset++] = (byte)(pixel & 0xFF);
                StreamSaver.buf[offset++] = (byte)(pixel >> 8 & 0xFF);
                StreamSaver.buf[offset++] = (byte)(pixel >> 16 & 0xFF);
                ++i2;
            }
            fileName = TgaWriter.saveImageData(name, StreamSaver.buf, 0, offset, w, h2, index);
        }
        catch (Exception e2) {
            System.out.println("Error: StreamSaver: " + e2);
        }
        return fileName;
    }

    public static String saveImageData(String name, byte[] data, int dataOffset, int dataSize, int width, int height, int index) {
        TgaWriter.setHeader(width, height);
        String fileName = TgaWriter.createFileName(name, index);
        try {
            FileOutputStream stream = new FileOutputStream(fileName);
            stream.write(tgaHeader);
            stream.write(data, dataOffset, dataSize);
            stream.close();
        }
        catch (Exception e2) {
            System.out.println("Error! TgaSaver:saveImageData :" + e2);
        }
        return fileName;
    }

    private static String createFileName(String name, int index) {
        String number = Integer.toString(index);
        int len = number.length();
        return String.valueOf(name) + "000000".substring(len) + number + ".tga";
    }

    private static void setHeader(int width, int height) {
        TgaWriter.tgaHeader[12] = (byte)(width & 0xFF);
        TgaWriter.tgaHeader[13] = (byte)((width & 0xFF00) >> 8);
        TgaWriter.tgaHeader[14] = (byte)(height & 0xFF);
        TgaWriter.tgaHeader[15] = (byte)((height & 0xFF00) >> 8);
        TgaWriter.tgaHeader[16] = format;
        TgaWriter.tgaHeader[17] = format == 32 ? 40 : 32;
    }

    private static void swapRGB(byte[] data) {
        int size = data.length;
        int i2 = 0;
        while (i2 < size) {
            byte t = data[i2];
            data[i2] = data[i2 + 2];
            data[i2 + 2] = t;
            i2 += 3;
        }
    }
}

