/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

public class WaveConvertor {
    protected static final byte[] CHUNK_FMT = new byte[]{102, 109, 116, 32};
    protected static final byte[] CHUNK_DATA = new byte[]{100, 97, 116, 97};
    protected static WaveConvertor instance;

    public byte[] convert(byte[] srcData, int[] dstParams) {
        return srcData;
    }

    protected int findChunk(byte[] data, byte[] chunk, int offset) {
        int size = data.length;
        if (offset < 0) {
            offset = 0;
        }
        byte c0 = chunk[0];
        byte c1 = chunk[1];
        byte c2 = chunk[2];
        byte c3 = chunk[3];
        int i2 = offset;
        while (i2 < size) {
            if (data[i2] == c0 && data[i2 + 1] == c1 && data[i2 + 2] == c2 && data[i2 + 3] == c3) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    protected int getChannelCount(byte[] data, int offset) {
        return this.getI2(data, offset + 2);
    }

    protected int getSamplingFreq(byte[] data, int offset) {
        return this.getI4(data, offset + 4);
    }

    protected int getBytesPerSec(byte[] data, int offset) {
        return this.getI4(data, offset + 8);
    }

    protected int getBlockAlign(byte[] data, int offset) {
        return this.getI2(data, offset + 12);
    }

    protected int getBitsPerSample(byte[] data, int offset) {
        return this.getI2(data, offset + 14);
    }

    protected int getExtraBytes(byte[] data, int offset) {
        return this.getI2(data, offset + 16);
    }

    protected int getSamplesPerBlock(byte[] data, int offset) {
        return this.getI2(data, offset + 18);
    }

    protected int getI4(byte[] data, int offset) {
        int i3 = 0;
        int i2 = 0;
        int i1 = 0;
        int i0 = 0;
        i0 |= data[offset++];
        i1 |= data[offset++];
        i2 |= data[offset++];
        i3 |= data[offset];
        return (i0 &= 0xFF) | (i1 &= 0xFF) << 8 | (i2 &= 0xFF) << 16 | (i3 &= 0xFF) << 24;
    }

    protected int getI2(byte[] data, int offset) {
        int i1 = 0;
        int i0 = 0;
        i0 |= data[offset++];
        i1 |= data[offset];
        return (i0 &= 0xFF) | (i1 &= 0xFF) << 8;
    }
}

