/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ScrollPaneAdjustable;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import javax.microedition.lcdui.Display;
import ole.pstros.ConfigData;

public class ZoomViewer
extends Canvas
implements WindowListener,
KeyListener {
    private static final int[] DIMENSIONS = new int[]{11, 15, 19};
    private static final boolean SHOW_TRANSFORM = false;
    private static Color COLOR_GRAY = new Color(0x9F9F9F);
    private Image image;
    private Frame parent;
    private Container container;
    private ScrollPaneAdjustable vScroll;
    private int mouseX;
    private int mouseY;
    private int spotX;
    private int spotY;
    private int spotColor;
    private int zoomFactor;
    private int cWidth;
    private int cHeight;

    public ZoomViewer(Frame parent, Image image, int zoom) {
        this.setBackground(COLOR_GRAY);
        this.parent = parent;
        this.addKeyListener(this);
        this.image = image;
        this.zoomFactor = zoom;
        this.spotX = -1;
        this.spotY = -1;
        this.setSize();
    }

    private void setSize() {
        this.cWidth = DIMENSIONS[this.zoomFactor - 1] * 20;
        this.cHeight = this.cWidth + 20;
    }

    public int getCurrentWidth() {
        return this.cWidth;
    }

    public int getCurrentHeight() {
        return this.cHeight;
    }

    public void paint(Graphics g2) {
        if (this.image == null) {
            g2.setColor(Color.GRAY);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            return;
        }
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillRect(0, 0, this.getWidth(), 20);
        g2.setColor(Color.BLACK);
        g2.drawString("x:" + this.mouseX + " y:" + this.mouseY, 0, 15);
        if (this.spotX > -1 && this.spotY > -1) {
            g2.drawString(" dx:" + (this.mouseX - this.spotX) + " dy:" + (this.mouseY - this.spotY), 70, 15);
        }
        g2.drawString("0x" + Integer.toHexString(this.spotColor), 150, 15);
        int pixWidth = DIMENSIONS[this.zoomFactor - 1];
        int mouseShift = pixWidth / 2;
        int srcX1 = this.mouseX - mouseShift;
        int srcX2 = this.mouseX - mouseShift + pixWidth;
        int srcY1 = this.mouseY - mouseShift;
        int srcY2 = this.mouseY - mouseShift + pixWidth;
        g2.drawImage(this.image, 0, 20, this.cWidth, this.cHeight, srcX1, srcY1, srcX2, srcY2, this);
        if (srcX1 < 0) {
            g2.setColor(Color.GRAY);
            g2.fillRect(0, 20, -20 * srcX1, this.cHeight);
        }
        if (srcX2 > Display.WIDTH) {
            int blockWidth = (srcX2 - Display.WIDTH) * 20;
            g2.setColor(Color.GRAY);
            g2.fillRect(this.cWidth - blockWidth, 20, blockWidth, this.cHeight);
        }
        if (srcY1 < 0) {
            g2.setColor(Color.GRAY);
            g2.fillRect(0, 20, this.cWidth, -20 * srcY1);
        }
        if (srcY2 > Display.HEIGHT) {
            int blockHeight = (srcY2 - Display.HEIGHT) * 20;
            g2.setColor(Color.GRAY);
            g2.fillRect(0, this.cHeight - blockHeight, this.cWidth, blockHeight);
        }
        g2.setColor(Color.RED);
        int posX = mouseShift * 20;
        int posY = posX + 20;
        g2.drawRect(posX, posY, 19, 19);
        g2.setColor(Color.BLACK);
        g2.drawRect(posX - 1, posY - 1, 21, 21);
    }

    public void updateView(int mx, int my, boolean force) {
        if (!force && mx == this.mouseX && my == this.mouseY) {
            return;
        }
        this.mouseX = mx;
        this.mouseY = my;
        this.repaint();
    }

    public void setSpot(int mx, int my) {
        this.spotX = mx;
        this.spotY = my;
        if (this.image instanceof BufferedImage) {
            this.spotColor = ((BufferedImage)this.image).getRGB(this.spotX, this.spotY);
            this.spotColor &= 0xFFFFFF;
        }
        this.repaint();
    }

    public void update(Graphics g2) {
        this.paint(g2);
    }

    public void storeBounds() {
        ConfigData.zoomViewerBounds = this.parent.getBounds();
    }

    public void windowActivated(WindowEvent e2) {
        this.requestFocus();
    }

    public void windowClosed(WindowEvent e2) {
    }

    public void windowClosing(WindowEvent e2) {
        ConfigData.zoomViewerBounds = this.parent.getBounds();
        this.parent.dispose();
    }

    public void windowDeactivated(WindowEvent e2) {
    }

    public void windowDeiconified(WindowEvent e2) {
    }

    public void windowIconified(WindowEvent e2) {
    }

    public void windowOpened(WindowEvent e2) {
    }

    public void mouseClicked(MouseEvent e2) {
    }

    public void keyPressed(KeyEvent e2) {
        int keyCode = e2.getKeyCode();
        char keyChar = e2.getKeyChar();
        int modifiers = e2.getModifiers();
        if (keyCode >= 49 && keyCode <= 51 && (modifiers & 8) != 0) {
            ConfigData.zoomSize = keyCode - 48;
            if (ConfigData.zoomSize == this.zoomFactor) {
                return;
            }
            this.zoomFactor = ConfigData.zoomSize;
            this.setSize();
            if (this.parent != null) {
                int w = this.getCurrentWidth();
                int h2 = this.getCurrentHeight();
                Insets insets = this.parent.getInsets();
                this.parent.setSize(w += insets.right + insets.left, h2 += insets.bottom + insets.top);
                this.parent.doLayout();
            }
        }
    }

    public void keyReleased(KeyEvent e2) {
    }

    public void keyTyped(KeyEvent e2) {
    }
}

