/*
 * Decompiled with CFR 0.152.
 */
package com.vodafone.v10.system.device;

import com.vodafone.v10.system.device.MailListener;
import com.vodafone.v10.system.device.RingStateListener;
import com.vodafone.v10.system.device.ScheduledAlarmListener;
import com.vodafone.v10.system.device.TelephonyListener;

public class DeviceControl {
    public static final int BATTERY = 1;
    public static final int FIELD_INTENSITY = 2;
    public static final int KEY_STATE = 3;
    public static final int VIBRATION = 4;
    public static final int BACK_LIGHT = 5;
    public static final int EIGHT_DIRECTIONS = 6;
    private static DeviceControl instance;
    private int deviceState;
    static MailListener mailListener;
    static RingStateListener ringStateListener;
    static ScheduledAlarmListener scheduledAlarmListener;
    static TelephonyListener telephonyListener;

    public static final DeviceControl getDefaultDeviceControl() {
        if (instance == null) {
            instance = new DeviceControl();
        }
        return instance;
    }

    public int getDeviceState(int deviceNo) {
        switch (deviceNo) {
            case 1: {
                return 100;
            }
            case 2: {
                return 100;
            }
            case 3: {
                return this.getKeyState();
            }
        }
        throw new IllegalStateException();
    }

    private int getKeyState() {
        return 0;
    }

    public boolean getKeyRepeatState(int key) {
        return false;
    }

    public boolean setKeyRepeatState(int key, boolean state) {
        return false;
    }

    public boolean isDeviceActive(int deviceNo) {
        switch (deviceNo) {
            case 1: 
            case 2: 
            case 6: {
                return (1 << deviceNo & this.deviceState) != 0;
            }
        }
        throw new IllegalStateException();
    }

    public boolean setDeviceActive(int deviceNo, boolean active) {
        switch (deviceNo) {
            case 1: 
            case 2: 
            case 6: {
                this.deviceState = active ? (this.deviceState |= 1 << deviceNo) : (this.deviceState &= ~(1 << deviceNo));
                return true;
            }
        }
        throw new IllegalStateException();
    }

    public static void setMailListener(MailListener listener) {
        mailListener = listener;
    }

    public static void setRingStateListener(RingStateListener listener) {
        ringStateListener = listener;
    }

    public static void setScheduledAlarmListener(ScheduledAlarmListener listener) {
        scheduledAlarmListener = listener;
    }

    public static void setTelephonyListener(TelephonyListener listener) {
        telephonyListener = listener;
    }
}

