/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Image;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import ole.pstros.ConfigData;
import ole.pstros.EmuCanvas;
import ole.pstros.MainApp;

public abstract class Canvas
extends Displayable {
    public static final int UP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int DOWN = 6;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int SOFT_L = 24;
    public static final int SOFT_C = 25;
    public static final int SOFT_R = 26;
    public static final int KEY_NUM0 = 48;
    public static final int KEY_NUM1 = 49;
    public static final int KEY_NUM2 = 50;
    public static final int KEY_NUM3 = 51;
    public static final int KEY_NUM4 = 52;
    public static final int KEY_NUM5 = 53;
    public static final int KEY_NUM6 = 54;
    public static final int KEY_NUM7 = 55;
    public static final int KEY_NUM8 = 56;
    public static final int KEY_NUM9 = 57;
    public static final int KEY_STAR = 42;
    public static final int KEY_POUND = 35;
    private static final int MASK_KEY_NUM0 = 1;
    private static final int MASK_KEY_NUM1 = 2;
    private static final int MASK_KEY_NUM2 = 4;
    private static final int MASK_KEY_NUM3 = 8;
    private static final int MASK_KEY_NUM4 = 16;
    private static final int MASK_KEY_NUM5 = 32;
    private static final int MASK_KEY_NUM6 = 64;
    private static final int MASK_KEY_NUM7 = 128;
    private static final int MASK_KEY_NUM8 = 256;
    private static final int MASK_KEY_NUM9 = 512;
    private static final int MASK_KEY_STAR = 1024;
    private static final int MASK_KEY_CROSS = 2048;
    private boolean fullScreen;
    private static final int DEFAULT_CONSOLE_SIZE = 24;

    protected Canvas() {
        this.displaybableAreaWidth = Display.WIDTH;
        this.emuCreateBridge();
        this.emuSetScreenMode(false);
        EmuCanvas ec = EmuCanvas.getInstance();
        if (ec != null) {
            ec.setBridge(this.emuLcduiBridge);
        }
    }

    boolean emuIsFullScreen() {
        return this.fullScreen;
    }

    public boolean isDoubleBuffered() {
        return true;
    }

    public boolean hasPointerEvents() {
        return true;
    }

    public boolean hasPointerMotionEvents() {
        return true;
    }

    public boolean hasRepeatEvents() {
        return true;
    }

    public int getKeyCode(int gameAction) {
        switch (gameAction) {
            case 1: {
                return ConfigData.keyUpArrow;
            }
            case 6: {
                return ConfigData.keyDownArrow;
            }
            case 2: {
                return ConfigData.keyLeftArrow;
            }
            case 5: {
                return ConfigData.keyRightArrow;
            }
            case 8: {
                return ConfigData.keyCenterSoft;
            }
            case 9: {
                return 49;
            }
            case 10: {
                return 51;
            }
            case 11: {
                return 55;
            }
            case 12: {
                return 57;
            }
        }
        return 0;
    }

    public String getKeyName(int keyCode) {
        if (MainApp.verbose) {
            System.out.println("Pstros: Canvas. getKeyName called. keyCode=" + keyCode);
        }
        return "key";
    }

    public int getGameAction(int keyCode) {
        if (keyCode == ConfigData.keyUpArrow || keyCode == 50) {
            return 1;
        }
        if (keyCode == ConfigData.keyDownArrow || keyCode == 56) {
            return 6;
        }
        if (keyCode == ConfigData.keyLeftArrow || keyCode == 52) {
            return 2;
        }
        if (keyCode == ConfigData.keyRightArrow || keyCode == 54) {
            return 5;
        }
        if (keyCode == ConfigData.keyCenterSoft || keyCode == 53) {
            return 8;
        }
        if (keyCode == 49) {
            return 9;
        }
        if (keyCode == 51) {
            return 10;
        }
        if (keyCode == 55) {
            return 11;
        }
        if (keyCode == 57) {
            return 12;
        }
        return 0;
    }

    public void setFullScreenMode(boolean mode) {
        boolean newMode;
        boolean bl = newMode = mode && ConfigData.fullScreenSupported;
        if (this.fullScreen != newMode) {
            this.emuSetScreenMode(newMode);
        }
    }

    void emuSetScreenMode(boolean mode) {
        this.fullScreen = mode;
        this.displaybableAreaWidth = Display.WIDTH;
        if (this.fullScreen) {
            this.displaybableAreaHeight = Display.HEIGHT;
        } else {
            int consoleSize = ConfigData.getConsoleSize();
            if (consoleSize < 1) {
                ConfigData.bottomConsoleHeight = consoleSize = 24;
            }
            this.displaybableAreaHeight = Display.HEIGHT - consoleSize;
        }
    }

    protected void keyPressed(int keyCode) {
    }

    protected void keyRepeated(int keyCode) {
    }

    protected void keyReleased(int keyCode) {
    }

    protected void pointerPressed(int x, int y) {
    }

    protected void pointerReleased(int x, int y) {
    }

    protected void pointerDragged(int x, int y) {
    }

    protected void showNotify() {
    }

    protected void hideNotify() {
    }

    protected abstract void paint(Graphics var1);

    void emuPointerPressed(int x, int y) {
        this.pointerPressed(x, y);
    }

    void emuPointerReleased(int x, int y) {
        this.pointerReleased(x, y);
    }

    void emuPointerDragged(int x, int y) {
        this.pointerDragged(x, y);
    }

    void emuSizeChanged(int w, int h2) {
        this.sizeChanged(w, h2);
    }

    Graphics emuGetGraphics() {
        if (this.emuCanvas != null) {
            return this.emuCanvas.getDeviceGraphics();
        }
        this.emuSetEmuCanvas(EmuCanvas.getInstance());
        if (this.emuCanvas != null) {
            return this.emuCanvas.getDeviceGraphics();
        }
        System.out.println("Pstros: GameCanvas.getGraphics() - emuCanvas is null!");
        return null;
    }

    int emuGetKeyStates() {
        return this.emuKeyStates;
    }

    void emuFlushGraphics() {
        if (this.emuCanvas != null) {
            this.emuCanvas.flushGraphics(null);
            this.emuCanvas.checkPause();
        }
    }

    void emuFlushGraphics(Image img) {
        if (this.emuCanvas != null) {
            this.emuCanvas.flushGraphics(img);
            this.emuCanvas.checkPause();
        }
    }

    void emuCleanKeys() {
        this.emuNumStates = 0;
    }

    boolean emuKeyAction(int key, int keyChar, int modifiers, int action) {
        int origKeyStates = this.emuKeyStates;
        boolean processed = super.emuKeyAction(key, keyChar, modifiers, action);
        if (action == 0) {
            if (key == Display.keyFire || key == Display.keyFire2) {
                if ((origKeyStates & 0x100) == 0) {
                    this.keyPressed(ConfigData.configActive ? ConfigData.keyCenterSoft : 8);
                } else {
                    this.keyRepeated(ConfigData.configActive ? ConfigData.keyCenterSoft : 8);
                }
            } else if (key == Display.keyLeft) {
                if ((origKeyStates & 4) == 0) {
                    this.keyPressed(ConfigData.configActive ? ConfigData.keyLeftArrow : 2);
                } else {
                    this.keyRepeated(ConfigData.configActive ? ConfigData.keyLeftArrow : 2);
                }
            } else if (key == Display.keyRight) {
                if ((origKeyStates & 0x20) == 0) {
                    this.keyPressed(ConfigData.configActive ? ConfigData.keyRightArrow : 5);
                } else {
                    this.keyRepeated(ConfigData.configActive ? ConfigData.keyRightArrow : 5);
                }
            } else if (key == Display.keyUp) {
                if ((origKeyStates & 2) == 0) {
                    this.keyPressed(ConfigData.configActive ? ConfigData.keyUpArrow : 1);
                } else {
                    this.keyRepeated(ConfigData.configActive ? ConfigData.keyUpArrow : 1);
                }
            } else if (key == Display.keyDown) {
                if ((origKeyStates & 0x40) == 0) {
                    this.keyPressed(ConfigData.configActive ? ConfigData.keyDownArrow : 6);
                } else {
                    this.keyRepeated(ConfigData.configActive ? ConfigData.keyDownArrow : 6);
                }
            } else if ((key == Display.keySoftLeft || key == Display.keySoftLeft2) && modifiers == 0) {
                if (!processed) {
                    if ((origKeyStates & 0x1000000) == 0) {
                        this.keyPressed(ConfigData.configActive ? ConfigData.keyLeftSoft : 24);
                    } else {
                        this.keyRepeated(ConfigData.configActive ? ConfigData.keyLeftSoft : 24);
                    }
                }
            } else if ((key == Display.keySoftRight || key == Display.keySoftRight2) && modifiers == 0) {
                if (!processed) {
                    if ((origKeyStates & 0x4000000) == 0) {
                        this.keyPressed(ConfigData.configActive ? ConfigData.keyRightSoft : 26);
                    } else {
                        this.keyRepeated(ConfigData.configActive ? ConfigData.keyRightSoft : 26);
                    }
                }
            } else if (key == Display.keyNum5) {
                if ((this.emuNumStates & 0x20) == 0) {
                    this.emuNumStates |= 0x20;
                    this.keyPressed(53);
                } else {
                    this.keyRepeated(53);
                }
            } else if (key == Display.keyNum1) {
                if (ConfigData.numKeySwap) {
                    if ((this.emuNumStates & 0x80) == 0) {
                        this.emuNumStates |= 0x80;
                        this.keyPressed(55);
                    } else {
                        this.keyRepeated(55);
                    }
                } else if ((this.emuNumStates & 2) == 0) {
                    this.emuNumStates |= 2;
                    this.keyPressed(49);
                } else {
                    this.keyRepeated(49);
                }
            } else if (key == Display.keyNum2) {
                if (ConfigData.numKeySwap) {
                    if ((this.emuNumStates & 0x100) == 0) {
                        this.emuNumStates |= 0x100;
                        this.keyPressed(56);
                    } else {
                        this.keyRepeated(56);
                    }
                } else if ((this.emuNumStates & 4) == 0) {
                    this.emuNumStates |= 4;
                    this.keyPressed(50);
                } else {
                    this.keyRepeated(50);
                }
            } else if (key == Display.keyNum3) {
                if (ConfigData.numKeySwap) {
                    if ((this.emuNumStates & 0x200) == 0) {
                        this.emuNumStates |= 0x200;
                        this.keyPressed(57);
                    } else {
                        this.keyRepeated(57);
                    }
                } else if ((this.emuNumStates & 8) == 0) {
                    this.emuNumStates |= 8;
                    this.keyPressed(51);
                } else {
                    this.keyRepeated(51);
                }
            } else if (key == Display.keyNum4) {
                if ((this.emuNumStates & 0x10) == 0) {
                    this.emuNumStates |= 0x10;
                    this.keyPressed(52);
                } else {
                    this.keyRepeated(52);
                }
            } else if (key == Display.keyNum6) {
                if ((this.emuNumStates & 0x40) == 0) {
                    this.emuNumStates |= 0x40;
                    this.keyPressed(54);
                } else {
                    this.keyRepeated(54);
                }
            } else if (key == Display.keyNum7) {
                if (ConfigData.numKeySwap) {
                    if ((this.emuNumStates & 2) == 0) {
                        this.emuNumStates |= 2;
                        this.keyPressed(49);
                    } else {
                        this.keyRepeated(49);
                    }
                } else if ((this.emuNumStates & 0x80) == 0) {
                    this.emuNumStates |= 0x80;
                    this.keyPressed(55);
                } else {
                    this.keyRepeated(55);
                }
            } else if (key == Display.keyNum8) {
                if (ConfigData.numKeySwap) {
                    if ((this.emuNumStates & 4) == 0) {
                        this.emuNumStates |= 4;
                        this.keyPressed(50);
                    } else {
                        this.keyRepeated(50);
                    }
                } else if ((this.emuNumStates & 0x100) == 0) {
                    this.emuNumStates |= 0x100;
                    this.keyPressed(56);
                } else {
                    this.keyRepeated(56);
                }
            } else if (key == Display.keyNum9) {
                if (ConfigData.numKeySwap) {
                    if ((this.emuNumStates & 8) == 0) {
                        this.emuNumStates |= 8;
                        this.keyPressed(51);
                    } else {
                        this.keyRepeated(51);
                    }
                } else if ((this.emuNumStates & 0x200) == 0) {
                    this.emuNumStates |= 0x200;
                    this.keyPressed(57);
                } else {
                    this.keyRepeated(57);
                }
            } else if (key == Display.keyNum0) {
                if ((this.emuNumStates & 1) == 0) {
                    this.emuNumStates |= 1;
                    this.keyPressed(48);
                } else {
                    this.keyRepeated(48);
                }
            } else if (key == Display.keyCross) {
                if ((this.emuNumStates & 0x800) == 0) {
                    this.emuNumStates |= 0x800;
                    this.keyPressed(35);
                } else {
                    this.keyRepeated(35);
                }
            } else if (key == Display.keyStar) {
                if ((this.emuNumStates & 0x400) == 0) {
                    this.emuNumStates |= 0x400;
                    this.keyPressed(42);
                } else {
                    this.keyRepeated(42);
                }
            } else if (key == Display.keyVirtual1) {
                this.keyPressed(1000000);
            }
            if (key == Display.keyVirtual2) {
                this.keyPressed(1000001);
            } else if (key == Display.keyVirtual3) {
                this.keyPressed(1000002);
            }
        } else if (action == 1) {
            if (key == Display.keyFire || key == Display.keyFire2) {
                if ((origKeyStates & 0x100) != 0) {
                    this.keyReleased(ConfigData.configActive ? ConfigData.keyCenterSoft : 8);
                }
            } else if (key == Display.keyLeft) {
                if ((origKeyStates & 4) != 0) {
                    this.keyReleased(ConfigData.configActive ? ConfigData.keyLeftArrow : 2);
                }
            } else if (key == Display.keyRight) {
                if ((origKeyStates & 0x20) != 0) {
                    this.keyReleased(ConfigData.configActive ? ConfigData.keyRightArrow : 5);
                }
            } else if (key == Display.keyUp) {
                if ((origKeyStates & 2) != 0) {
                    this.keyReleased(ConfigData.configActive ? ConfigData.keyUpArrow : 1);
                }
            } else if (key == Display.keyDown) {
                if ((origKeyStates & 0x40) != 0) {
                    this.keyReleased(ConfigData.configActive ? ConfigData.keyDownArrow : 6);
                }
            } else if ((key == Display.keySoftLeft || key == Display.keySoftLeft2) && modifiers == 0) {
                if ((origKeyStates & 0x1000000) != 0) {
                    this.keyReleased(ConfigData.configActive ? ConfigData.keyLeftSoft : 24);
                }
            } else if ((key == Display.keySoftRight || key == Display.keySoftRight2) && modifiers == 0) {
                if ((origKeyStates & 0x4000000) != 0) {
                    this.keyReleased(ConfigData.configActive ? ConfigData.keyRightSoft : 26);
                }
            } else if (key == Display.keyNum5) {
                if ((this.emuNumStates & 0x20) != 0) {
                    this.emuNumStates &= 0xFFFFFFDF;
                    this.keyReleased(53);
                }
            } else if (key == Display.keyNum0) {
                if ((this.emuNumStates & 1) != 0) {
                    this.emuNumStates &= 0xFFFFFFFE;
                    this.keyReleased(48);
                }
            } else if (key == Display.keyNum1) {
                if (ConfigData.numKeySwap) {
                    if ((this.emuNumStates & 0x80) != 0) {
                        this.emuNumStates &= 0xFFFFFF7F;
                        this.keyReleased(55);
                    }
                } else if ((this.emuNumStates & 2) != 0) {
                    this.emuNumStates &= 0xFFFFFFFD;
                    this.keyReleased(49);
                }
            } else if (key == Display.keyNum2) {
                if (ConfigData.numKeySwap) {
                    if ((this.emuNumStates & 0x100) != 0) {
                        this.emuNumStates &= 0xFFFFFEFF;
                        this.keyReleased(56);
                    }
                } else if ((this.emuNumStates & 4) != 0) {
                    this.emuNumStates &= 0xFFFFFFFB;
                    this.keyReleased(50);
                }
            } else if (key == Display.keyNum3) {
                if (ConfigData.numKeySwap) {
                    if ((this.emuNumStates & 0x200) != 0) {
                        this.emuNumStates &= 0xFFFFFDFF;
                        this.keyReleased(57);
                    }
                } else if ((this.emuNumStates & 8) != 0) {
                    this.emuNumStates &= 0xFFFFFFF7;
                    this.keyReleased(51);
                }
            } else if (key == Display.keyNum4) {
                if ((this.emuNumStates & 0x10) != 0) {
                    this.emuNumStates &= 0xFFFFFFEF;
                    this.keyReleased(52);
                }
            } else if (key == Display.keyNum6) {
                if ((this.emuNumStates & 0x40) != 0) {
                    this.emuNumStates &= 0xFFFFFFBF;
                    this.keyReleased(54);
                }
            } else if (key == Display.keyNum7) {
                if (ConfigData.numKeySwap) {
                    if ((this.emuNumStates & 2) != 0) {
                        this.emuNumStates &= 0xFFFFFFFD;
                        this.keyReleased(49);
                    }
                } else if ((this.emuNumStates & 0x80) != 0) {
                    this.emuNumStates &= 0xFFFFFF7F;
                    this.keyReleased(55);
                }
            } else if (key == Display.keyNum8) {
                if (ConfigData.numKeySwap) {
                    if ((this.emuNumStates & 4) != 0) {
                        this.emuNumStates &= 0xFFFFFFFB;
                        this.keyReleased(50);
                    }
                } else if ((this.emuNumStates & 0x100) != 0) {
                    this.emuNumStates &= 0xFFFFFEFF;
                    this.keyReleased(56);
                }
            } else if (key == Display.keyNum9) {
                if (ConfigData.numKeySwap) {
                    if ((this.emuNumStates & 8) != 0) {
                        this.emuNumStates &= 0xFFFFFFF7;
                        this.keyReleased(51);
                    }
                } else if ((this.emuNumStates & 0x200) != 0) {
                    this.emuNumStates &= 0xFFFFFDFF;
                    this.keyReleased(57);
                }
            } else if (key == Display.keyCross) {
                if ((this.emuNumStates & 0x800) != 0) {
                    this.emuNumStates &= 0xFFFFF7FF;
                    this.keyReleased(35);
                }
            } else if (key == Display.keyStar) {
                if ((this.emuNumStates & 0x400) != 0) {
                    this.emuNumStates &= 0xFFFFFBFF;
                    this.keyReleased(42);
                }
            } else if (key == Display.keyVirtual1) {
                this.keyReleased(1000000);
            }
            if (key == Display.keyVirtual2) {
                this.keyReleased(1000001);
            } else if (key == Display.keyVirtual3) {
                this.keyReleased(1000002);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void repaint(int x, int y, int width, int height) {
        if (MainApp.verbose) {
            System.out.println("Pstros: repaint called 1 ec=" + this.emuCanvas + " x=" + x + " y=" + y + " w=" + width + " h=" + height);
        }
        if (this.emuCanvas != null) {
            int[] nArray = this.emuCanvas.paintLock;
            // MONITORENTER : this.emuCanvas.paintLock
            this.emuCanvas.paintLock[0] = this.emuCanvas.paintLock[0] + 1;
            this.emuCanvas.setEmuPaintRequest(x, y, width, height);
            if (ConfigData.slaveMode) {
                this.emuCanvas.update();
            } else {
                this.emuCanvas.repaint(x, y, width, height);
            }
            // MONITOREXIT : nArray
            this.emuCanvas.checkPause();
        }
        if (!MainApp.verbose) return;
        System.out.println("Pstros: Canvas.repaint called emuCanvas=" + this.emuCanvas);
    }

    public final void repaint() {
        this.repaint(0, 0, Display.WIDTH, Display.HEIGHT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void serviceRepaints() {
        if (MainApp.verbose) {
            System.out.println("Pstros: Canvas.serviceRepaints called emuCanvas=" + this.emuCanvas);
        }
        if (this.emuCanvas == null) return;
        int safeUnlock = 10;
        while (this.emuCanvas.paintRequestValid() && safeUnlock > 0) {
            --safeUnlock;
            Thread.yield();
            try {
                Thread.sleep(2L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int[] nArray = this.emuCanvas.paintLock;
        synchronized (this.emuCanvas.paintLock) {
            if (this.emuCanvas.paintLock[0] > 0) {
                if (MainApp.verbose && this.emuCanvas.paintLock[0] > 1) {
                    System.out.println("Pstros: ?? paint lock=" + this.emuCanvas.paintLock[0]);
                }
                safeUnlock = 500;
                while (this.emuCanvas.isPainting() && safeUnlock > 0) {
                    try {
                        Thread.sleep(2L);
                        --safeUnlock;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.emuCanvas.paintLock[0] = 0;
            }
            if (this.emuCanvas.paintRequestValid()) {
                this.emuCanvas.flushGraphics(null);
            }
            // ** MonitorExit[var2_3] (shouldn't be in output)
            this.emuCanvas.checkPause();
            return;
        }
    }

    protected void sizeChanged(int w, int h2) {
    }

    void emuPaint(Graphics g2, Object o2) {
        if (MainApp.verbose) {
            System.out.println("**canvas paint! caller=" + o2);
        }
        this.paint(g2);
    }

    void emuPaint(java.awt.Graphics g2) {
    }

    void emuShowNotify() {
        try {
            this.showNotify();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.emuSetShown(true);
    }

    void emuHideNotify() {
        try {
            this.hideNotify();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.emuSetShown(false);
    }
}

