/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Vector;
import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import ole.pstros.MainApp;
import ole.pstros.utils.Pair;

public class ChoiceGroup
extends Item
implements Choice {
    private static final String NONE = "";
    private int type;
    protected Vector items;
    protected int selected;
    private int fitPolicy;
    private Font font;
    private boolean[] flags;
    private static final int[] triangleX;
    private static final int[] triangleY;

    static {
        int[] nArray = new int[3];
        nArray[1] = 8;
        nArray[2] = 4;
        triangleX = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = -4;
        nArray2[1] = -4;
        triangleY = nArray2;
    }

    public ChoiceGroup(String label, int choiceType) {
        this.label = label;
        this.type = choiceType;
        this.items = new Vector();
        this.selected = -1;
        this.font = Font.getDefaultFont();
        this.emuInteractive = true;
        if (choiceType != 4) {
            this.emuMultiElement = true;
        }
    }

    public ChoiceGroup(String label, int choiceType, String[] stringElements, Image[] imageElements) {
        this(label, choiceType);
        int size = stringElements.length;
        int i2 = 0;
        while (i2 < size) {
            Image img = null;
            if (imageElements != null) {
                img = imageElements[i2];
            }
            this.append(stringElements[i2], img);
            ++i2;
        }
        if (choiceType != 4) {
            this.emuMultiElement = true;
        }
    }

    public int append(String stringPart, Image imagePart) {
        if (this.selected == -1) {
            this.selected = 0;
        }
        if (MainApp.verbose) {
            System.out.println("append: " + stringPart + " image=" + imagePart);
        }
        Pair p2 = new Pair(stringPart, imagePart);
        this.items.add(p2);
        this.updateFlags(-1);
        return this.items.indexOf(p2);
    }

    public void delete(int elementNum) {
        this.items.remove(elementNum);
        this.selected = 0;
        if (this.items.size() < 1) {
            this.selected = -1;
        }
    }

    public void deleteAll() {
        this.items.removeAllElements();
        this.selected = -1;
    }

    public int size() {
        return this.items.size();
    }

    public String getString(int elementNum) {
        Pair pair = (Pair)this.items.get(elementNum);
        if (pair == null) {
            return null;
        }
        return (String)pair.getFirst();
    }

    public Image getImage(int elementNum) {
        Pair pair = (Pair)this.items.get(elementNum);
        if (pair == null) {
            return null;
        }
        return (Image)pair.getSecond();
    }

    public void insert(int elementNum, String stringPart, Image imagePart) {
        if (this.selected == -1) {
            this.selected = 0;
        }
        Pair p2 = new Pair(stringPart, imagePart);
        this.items.insertElementAt(p2, elementNum);
        this.updateFlags(elementNum);
    }

    public void set(int elementNum, String stringPart, Image imagePart) {
        Pair p2 = (Pair)this.items.get(elementNum);
        p2.set(stringPart, imagePart);
    }

    public boolean isSelected(int elementNum) {
        return this.selected == elementNum;
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public int getSelectedFlags(boolean[] selectedArray_return) {
        int result = 0;
        int i2 = 0;
        while (i2 < this.flags.length) {
            selectedArray_return[i2] = this.flags[i2];
            if (this.flags[i2]) {
                ++result;
            }
            ++i2;
        }
        i2 = this.flags.length;
        while (i2 < selectedArray_return.length) {
            selectedArray_return[i2] = false;
            ++i2;
        }
        if (this.type == 4 || this.type == 1 && this.selected >= 0) {
            selectedArray_return[this.selected] = true;
            return 1;
        }
        return result;
    }

    public void setSelectedIndex(int elementNum, boolean selected) {
        boolean update = false;
        if (this.type == 2 || this.type == 1) {
            this.flags[elementNum] = selected;
            update = true;
        } else if (selected && elementNum >= 0 && elementNum < this.items.size()) {
            this.selected = elementNum;
            update = true;
        }
        if (update) {
            this.emuUpdateScreen();
        }
    }

    public void setSelectedFlags(boolean[] selectedArray) {
        if (this.flags == null) {
            this.flags = new boolean[this.items.size()];
        }
        if (this.type == 2 || this.type == 1) {
            int i2 = 0;
            while (i2 < this.flags.length) {
                this.flags[i2] = selectedArray[i2];
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < this.flags.length) {
                if (selectedArray[i3]) {
                    this.selected = i3;
                    break;
                }
                ++i3;
            }
        }
        this.emuUpdateScreen();
    }

    public void setFitPolicy(int fitPolicy) {
        this.fitPolicy = fitPolicy;
    }

    public int getFitPolicy() {
        return this.fitPolicy;
    }

    public void setFont(int elementNum, Font font) {
        if (font == null) {
            font = Font.getDefaultFont();
        } else {
            this.font = font;
        }
    }

    public Font getFont(int elementNum) {
        return this.font;
    }

    private void updateFlags(int startIndex) {
        int size = this.items.size();
        if (size == 1) {
            this.flags = new boolean[1];
            return;
        }
        boolean[] tmpFlags = new boolean[size];
        if (startIndex < 0) {
            System.arraycopy(this.flags, 0, tmpFlags, 0, this.flags.length);
        } else {
            if (startIndex > 0) {
                System.arraycopy(this.flags, 0, tmpFlags, 0, startIndex);
            }
            System.arraycopy(this.flags, startIndex, tmpFlags, startIndex + 1, this.flags.length - startIndex);
        }
        this.flags = tmpFlags;
    }

    int emuPaint(Graphics g2, int x, int y) {
        java.awt.Font font = g2.getFont();
        int height = font.getSize() + 2;
        int width = Display.WIDTH - x - 2;
        int origY = y;
        Color paintColor = Color.BLACK;
        if (this.emuActive) {
            paintColor = Color.RED;
        }
        g2.setColor(paintColor);
        if (this.label != null) {
            g2.drawString(this.label, x + 2, y + 1);
            y += height + 2;
        }
        Pair p2 = (Pair)this.items.get(this.selected);
        if (this.type == 4) {
            if (this.emuActive) {
                g2.setColor(COLOR_HIGHLIGT);
                g2.fillRect(x, y - height + 2, Display.WIDTH - 4, height + 2);
                g2.setColor(paintColor);
            }
            g2.drawString((String)p2.getFirst(), x + 2, y + 1);
            g2.drawRect(x, y - height + 2, Display.WIDTH - 4, height + 2);
            g2.translate(Display.WIDTH - 16, y);
            g2.fillPolygon(triangleX, triangleY, 3);
            g2.translate(-(Display.WIDTH - 16), -y);
            y += height + 2;
            y += 4;
        } else if (this.type == 2) {
            int size = this.items.size();
            int i2 = 0;
            while (i2 < size) {
                p2 = (Pair)this.items.get(i2);
                if (i2 == this.selected && this.emuActive) {
                    g2.setColor(COLOR_HIGHLIGT);
                    g2.fillRect(x, y - height + 2, Display.WIDTH - 4, height + 2);
                    g2.setColor(paintColor);
                }
                g2.drawRect(x + 2, y - height + 4, 8, height - 2);
                if (this.flags[i2]) {
                    g2.drawLine(x + 4, y - height + 6, x + 8, y);
                    g2.drawLine(x + 4, y, x + 8, y - height + 6);
                }
                g2.drawString((String)p2.getFirst(), x + 12, y + 1);
                y += height + 2;
                ++i2;
            }
            y += 2;
        } else if (this.type == 1) {
            int size = this.items.size();
            int i3 = 0;
            while (i3 < size) {
                p2 = (Pair)this.items.get(i3);
                if (i3 == this.selected && this.emuActive) {
                    g2.setColor(COLOR_HIGHLIGT);
                    g2.fillRect(x, y - height + 2, Display.WIDTH - 4, height + 2);
                    g2.setColor(paintColor);
                }
                g2.drawRect(x + 2, y - height + 4, 8, height - 2);
                if (this.flags[i3]) {
                    g2.fillRect(x + 4, y - height + 7, 5, height - 7);
                }
                g2.drawString((String)p2.getFirst(), x + 12, y + 1);
                y += height + 2;
                ++i3;
            }
            y += 2;
        }
        return y - origY;
    }

    int emuGetHeight(Graphics g2) {
        java.awt.Font font = g2.getFont();
        int height = font.getSize();
        int h2 = height + 4;
        if (this.type == 4) {
            height = h2;
            if (this.label != null && this.label.length() > 0) {
                height += h2;
            }
            height += 4;
        } else if (this.type == 2 || this.type == 1) {
            height = 0;
            if (this.label != null && this.label.length() > 0) {
                height = h2;
            }
            int size = this.items.size();
            height += h2 * size;
            height += 2;
        }
        return height;
    }

    int emuGetElementHeight(Graphics g2) {
        if (!this.emuMultiElement) {
            return this.emuGetHeight(g2);
        }
        java.awt.Font font = g2.getFont();
        int height = font.getSize();
        int h2 = height + 4;
        height = 0;
        if (this.label != null && this.label.length() > 0) {
            height = h2;
        }
        height += h2 * (this.selected + 1);
        return height += 2;
    }

    int emuGetYSpace(Graphics g2) {
        java.awt.Font font = g2.getFont();
        return font.getSize() + 3;
    }

    void emuActionPressed() {
        boolean update = false;
        if (this.type == 4) {
            int max = this.items.size();
            ++this.selected;
            if (this.selected >= max) {
                this.selected = 0;
            }
            update = true;
        } else if (this.type == 2) {
            this.flags[this.selected] = !this.flags[this.selected];
        } else if (this.type == 1) {
            int i2 = 0;
            while (i2 < this.flags.length) {
                this.flags[i2] = false;
                ++i2;
            }
            this.flags[this.selected] = true;
        }
        if (update) {
            this.emuUpdateScreen();
        }
    }

    boolean emuMoveSelectionDown() {
        if (this.type == 2 || this.type == 1) {
            if (this.selected == this.items.size() - 1) {
                return true;
            }
            ++this.selected;
            this.emuUpdateScreen();
            return false;
        }
        return true;
    }

    boolean emuMoveSelectionUp() {
        if (this.type == 2 || this.type == 1) {
            if (this.selected == 0) {
                return true;
            }
            --this.selected;
            this.emuUpdateScreen();
            return false;
        }
        return true;
    }
}

