/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Item;

public class Gauge
extends Item {
    public static final int INDEFINITE = -1;
    public static final int CONTINUOUS_IDLE = 0;
    public static final int INCREMENTAL_IDLE = 1;
    public static final int CONTINUOUS_RUNNING = 2;
    public static final int INCREMENTAL_UPDATING = 3;
    private boolean interactive;
    private int maxVal;
    private int curVal;
    private int w = 100;
    private int h = 6;

    public Gauge(String label, boolean interactive, int maxValue, int initialValue) {
        this.setLabel(label);
        this.interactive = interactive;
        this.maxVal = maxValue;
        this.curVal = initialValue;
    }

    public int getMaxValue() {
        return this.maxVal;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setMaxValue(int maxValue) {
        this.maxVal = maxValue;
    }

    public int getValue() {
        if (this.curVal == -1) {
            return 0;
        }
        return this.curVal;
    }

    public void setValue(int value) {
        if (value < 0) {
            value = 0;
        } else if (value > this.maxVal && this.maxVal > 0) {
            value = this.maxVal;
        }
        this.curVal = value;
        this.emuUpdateScreen();
    }

    public void setPreferredSize(int width, int height) {
        this.w = width;
        this.h = height;
    }

    int emuPaint(Graphics g2, int x, int y) {
        int totalH = 0;
        g2.setColor(Color.BLACK);
        if (this.label != null) {
            g2.drawString(this.label, x, y);
            Font font = g2.getFont();
            totalH = font.getSize() + 2;
            y += totalH;
        }
        if (this.w > Display.WIDTH - x - 4) {
            this.w = Display.WIDTH - x - 4;
        }
        if (this.h > 16) {
            this.h = 16;
        }
        g2.drawRect(x, y, this.w, this.h);
        int gauge = this.curVal * this.w / this.maxVal;
        g2.fillRect(x, y, gauge, this.h);
        return totalH + this.h + 2;
    }

    int emuGetHeight(Graphics g2) {
        int totalH = 0;
        if (this.label != null) {
            Font font = g2.getFont();
            totalH = font.getSize() + 2;
        }
        if (this.h > 16) {
            this.h = 16;
        }
        return totalH + this.h + 2;
    }
}

