/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import ole.pstros.ConfigData;
import ole.pstros.MainApp;
import ole.pstros.exterior.ObjectProvider;
import ole.pstros.reference.ImageReferenceManager;
import ole.pstros.utils.BaseClassLoader;
import ole.pstros.utils.ImageCreator;

public class Image
implements ObjectProvider {
    private static int[] tmpPixels;
    private java.awt.Image[] emuImages;
    private int width;
    private int height;
    private boolean[] emuValid;
    private boolean[][] collisionData;
    Graphics graphics;
    private static BufferedImage cacheImage;
    private static int cacheImageW;
    private static int cacheImageH;
    private static java.awt.Graphics cacheGraphics;

    private Image(java.awt.Image image) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        this.emuImages = new java.awt.Image[8];
        this.collisionData = new boolean[8][];
        this.emuValid = new boolean[8];
        this.emuImages[0] = image;
        if (this.emuImages[0] == null) {
            System.out.println("Image constructor: null emuImage!");
        }
        this.width = this.emuImages[0].getWidth(null);
        this.height = this.emuImages[0].getHeight(null);
        try {
            ImageReferenceManager.addImage(this);
        }
        catch (Exception e2) {
            System.out.println(e2);
            e2.printStackTrace();
        }
    }

    java.awt.Image emuGetImage(int transform) {
        java.awt.Image result = this.emuImages[transform];
        if (transform != 0 && !this.emuValid[transform]) {
            this.emuCreateTransformedImage(transform);
            result = this.emuImages[transform];
            this.emuValid[transform] = true;
        }
        return result;
    }

    boolean[] emuGetCollisionData(int transform) {
        boolean[] result = this.collisionData[transform];
        if (result == null) {
            this.emuCreateCollisionData(transform);
            result = this.collisionData[transform];
        }
        return result;
    }

    public Object getObject() {
        return this.emuImages[0];
    }

    private void emuCreateCollisionData(int transform) {
        int imgW = this.getWidth();
        int imgH = this.getHeight();
        boolean[] data = new boolean[imgW * imgH];
        if (transform > 3) {
            int tmp = imgW;
            imgW = imgH;
            imgH = tmp;
        }
        if (this.emuGetImage(transform) instanceof BufferedImage) {
            BufferedImage img = (BufferedImage)this.emuGetImage(transform);
            int[] rgb = new int[imgW * imgH];
            img.getRGB(0, 0, imgW, imgH, rgb, 0, imgW);
            int i2 = 0;
            while (i2 < data.length) {
                data[i2] = (rgb[i2] & 0xFF000000) == -16777216;
                ++i2;
            }
        } else {
            int i3 = 0;
            while (i3 < data.length) {
                data[i3] = true;
                ++i3;
            }
        }
        this.collisionData[transform] = data;
    }

    private void emuCreateTransformedImage(int transform) {
        java.awt.Image src = this.emuImages[0];
        int w = src.getWidth(null);
        int h2 = src.getHeight(null);
        this.emuImages[transform] = Image.emuCreateTransformedImage(src, 0, 0, w, h2, transform);
    }

    private static BufferedImage emuCreateTransformedImage(java.awt.Image src, int x, int y, int w, int h2, int transform) {
        BufferedImage dst = null;
        if (src == null) {
            return null;
        }
        BufferedImage tmpImage = new BufferedImage(w, h2, 2);
        Graphics2D g2 = tmpImage.createGraphics();
        g2.drawImage(src, -x, -y, null);
        if (transform == 0) {
            return tmpImage;
        }
        int[] dataSrc = new int[w * h2];
        int[] dataDst = new int[w * h2];
        tmpImage.getRGB(0, 0, w, h2, dataSrc, 0, w);
        switch (transform) {
            case 1: {
                Image.emuHorizontalSwap(dataDst, dataSrc, w, h2);
                dst = new BufferedImage(w, h2, 2);
                dst.setRGB(0, 0, w, h2, dataDst, 0, w);
                break;
            }
            case 7: {
                Image.emuHorizontalSwap(dataDst, dataSrc, w, h2);
                System.arraycopy(dataDst, 0, dataSrc, 0, w * h2);
                Image.emuRotate270(dataDst, dataSrc, w, h2);
                dst = new BufferedImage(h2, w, 2);
                dst.setRGB(0, 0, h2, w, dataDst, 0, h2);
                break;
            }
            case 4: {
                Image.emuHorizontalSwap(dataDst, dataSrc, w, h2);
                System.arraycopy(dataDst, 0, dataSrc, 0, w * h2);
                Image.emuRotate90(dataDst, dataSrc, w, h2);
                dst = new BufferedImage(h2, w, 2);
                dst.setRGB(0, 0, h2, w, dataDst, 0, h2);
                break;
            }
            case 2: {
                Image.emuVerticalSwap(dataDst, dataSrc, w, h2);
                dst = new BufferedImage(w, h2, 2);
                dst.setRGB(0, 0, w, h2, dataDst, 0, w);
                break;
            }
            case 3: {
                Image.emuHorizontalSwap(dataDst, dataSrc, w, h2);
                System.arraycopy(dataDst, 0, dataSrc, 0, w * h2);
                Image.emuVerticalSwap(dataDst, dataSrc, w, h2);
                dst = new BufferedImage(w, h2, 2);
                dst.setRGB(0, 0, w, h2, dataDst, 0, w);
                break;
            }
            case 5: {
                Image.emuRotate90(dataDst, dataSrc, w, h2);
                dst = new BufferedImage(h2, w, 2);
                dst.setRGB(0, 0, h2, w, dataDst, 0, h2);
                break;
            }
            case 6: {
                Image.emuRotate270(dataDst, dataSrc, w, h2);
                dst = new BufferedImage(h2, w, 2);
                dst.setRGB(0, 0, h2, w, dataDst, 0, h2);
                break;
            }
            default: {
                dst = tmpImage;
                System.out.println("Pstros: Image.emuCreateTransformedImage() - Unsupported transform! " + transform);
            }
        }
        return dst;
    }

    private static void emuHorizontalSwap(int[] dataDst, int[] dataSrc, int w, int h2) {
        int y = 0;
        while (y < h2) {
            int baseSrc = y * w;
            int baseDst = (h2 - y - 1) * w;
            int x = 0;
            while (x < w) {
                dataDst[baseDst + x] = dataSrc[baseSrc + x];
                ++x;
            }
            ++y;
        }
    }

    private static void emuVerticalSwap(int[] dataDst, int[] dataSrc, int w, int h2) {
        int x = 0;
        while (x < w) {
            int baseSrc = x;
            int baseDst = w - x - 1;
            int y = 0;
            while (y < h2) {
                dataDst[baseDst] = dataSrc[baseSrc];
                baseDst += w;
                baseSrc += w;
                ++y;
            }
            ++x;
        }
    }

    private static void emuRotate90(int[] dataDst, int[] dataSrc, int w, int h2) {
        int y = 0;
        while (y < h2) {
            int baseSrc = y * w;
            int baseDst = h2 - y - 1;
            int x = 0;
            while (x < w) {
                dataDst[baseDst + x * h2] = dataSrc[baseSrc + x];
                ++x;
            }
            ++y;
        }
    }

    private static void emuRotate270(int[] dataDst, int[] dataSrc, int w, int h2) {
        int y = 0;
        while (y < h2) {
            int baseSrc = y * w;
            int baseDst = h2 * (w - 1) + y;
            int x = 0;
            while (x < w) {
                dataDst[baseDst - x * h2] = dataSrc[baseSrc + x];
                ++x;
            }
            ++y;
        }
    }

    public static Image createImage(int w, int h2) {
        if (w < 1 || h2 < 1) {
            throw new IllegalArgumentException("wrong image size");
        }
        Image image = new Image(ImageCreator.createImage(w, h2, -16711936));
        if (MainApp.verbose) {
            System.out.println("Image.createImage(w, h) w=" + w + " h=" + h2 + " image=" + image.hashCode());
        }
        return image;
    }

    public static Image createImage(Image source) {
        if (MainApp.verbose) {
            System.out.println("Image.createImage(Image source).. ");
        }
        if (source == null) {
            throw new NullPointerException("source image is null");
        }
        BufferedImage bi = Image.emuCreateTransformedImage(source.emuGetImage(0), 0, 0, source.getWidth(), source.getHeight(), 0);
        return new Image(bi);
    }

    public static Image createImage(String name) throws IOException {
        byte[] data;
        if (MainApp.verbose) {
            System.out.println("Image.createImage(String name) =" + name);
        }
        BaseClassLoader loader = MainApp.getClassLoader();
        if (name == null) {
            if (MainApp.verbose) {
                System.out.println("resource name is null");
            }
            throw new NullPointerException("resource name is null");
        }
        if (loader != null) {
            data = loader.getResourceAsByteArray(name);
        } else {
            InputStream is = MainApp.midlet.getClass().getResourceAsStream(name);
            DataInputStream stream = new DataInputStream(is);
            data = null;
            int dataOffset = 0;
            try {
                int size = stream.available();
                while (size > 0) {
                    if (data == null) {
                        data = new byte[size];
                    } else {
                        byte[] newData = new byte[dataOffset + size];
                        System.arraycopy(data, 0, newData, 0, dataOffset);
                        data = newData;
                    }
                    stream.readFully(data, dataOffset, size);
                    dataOffset += size;
                    size = stream.available();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            stream.close();
            is.close();
        }
        if (data == null) {
            if (MainApp.verbose) {
                System.out.println("resource not found");
            }
            throw new IOException("resource not found");
        }
        ImageCreator ie = new ImageCreator();
        Image result = new Image(ie.createImage(data));
        if (MainApp.verbose) {
            System.out.println(" image created=" + result + " w=" + result.getWidth() + " h=" + result.getHeight());
        }
        return result;
    }

    public static Image createImage(byte[] imageData, int imageOffset, int imageLength) {
        byte[] data;
        if (MainApp.verbose) {
            System.out.println("Image.createImage(byte[] imageData, int imageOffset, int imageLength)  data.length=" + imageData.length + " offset=" + imageOffset + " length=" + imageLength);
        }
        if (imageData == null) {
            throw new NullPointerException("imageData is null");
        }
        if (imageOffset == 0 && imageData.length == imageLength) {
            data = imageData;
        } else {
            data = new byte[imageLength];
            System.arraycopy(imageData, imageOffset, data, 0, imageLength);
        }
        ImageCreator ie = new ImageCreator();
        Image result = new Image(ie.createImage(data));
        if (MainApp.verbose) {
            System.out.println(" image created=" + result + " w=" + result.getWidth() + " h=" + result.getHeight());
        }
        return result;
    }

    public static Image createImage(Image image, int x, int y, int width, int height, int transform) {
        BufferedImage bi;
        if (MainApp.verbose) {
            System.out.println("Image.createImage(Image image, int x, int y, int width, int height, int transform) x=" + x + " y=" + y + " transform=" + transform);
        }
        if ((bi = Image.emuCreateTransformedImage(image.emuGetImage(0), x, y, width, height, transform)) == null) {
            return null;
        }
        if (ConfigData.storeImages) {
            ImageCreator.saveImage(bi);
        }
        return new Image(bi);
    }

    public static Image createImage(int width, int height, int colorARGB) {
        Image result = new Image(ImageCreator.createImage(width, height, colorARGB));
        if (MainApp.verbose) {
            System.out.println("Image.createImage(w, h, colorARGB) w=" + width + " h=" + height + " image=" + result);
        }
        return result;
    }

    public static Image createImage(InputStream stream) throws IOException {
        if (stream == null) {
            throw new NullPointerException("input stream is null");
        }
        ImageCreator ie = new ImageCreator();
        int size = stream.available();
        byte[] data = new byte[size];
        int offset = 0;
        while (size > 0) {
            int red = stream.read(data, offset, size);
            offset += red;
            size -= red;
        }
        Image result = new Image(ie.createImage(data));
        return result;
    }

    public static Image createRGBImage(int[] rgb, int width, int height, boolean processAlpha) {
        if (width < 1 || height < 1) {
            throw new IllegalArgumentException("wrong image size");
        }
        BufferedImage bi = ImageCreator.createBufferedImage(width, height, -16711936);
        if (!processAlpha) {
            int size = rgb.length;
            if (tmpPixels == null || tmpPixels.length < size) {
                tmpPixels = new int[size];
            }
            System.arraycopy(rgb, 0, tmpPixels, 0, size);
            int i2 = 0;
            while (i2 < size) {
                int n2 = i2++;
                tmpPixels[n2] = tmpPixels[n2] | 0xFF000000;
            }
            bi.setRGB(0, 0, width, height, tmpPixels, 0, width);
        } else {
            bi.setRGB(0, 0, width, height, rgb, 0, width);
        }
        Image image = new Image(bi);
        if (MainApp.verbose) {
            System.out.println("Image.createRGBImage(w, h) w=" + width + " h=" + height + " image=" + image.hashCode());
        }
        return image;
    }

    public Graphics getGraphics() throws IllegalStateException {
        if (this.emuImages[0] == null) {
            System.out.println("Error: getGraphics: emuImage  is null!");
            return null;
        }
        if (this.graphics != null) {
            return this.graphics;
        }
        Graphics result = new Graphics();
        result.emuSetGraphics(this.emuImages[0].getGraphics());
        result.emuSetGraphicsImage((BufferedImage)this.emuImages[0]);
        result.emuSetImage(this);
        result.setClip(0, 0, this.width + 1, this.height + 1);
        result.setColor(0);
        result.setFont(Font.getDefaultFont());
        result.setStrokeStyle(0);
        if (MainApp.verbose) {
            System.out.println("Image: get graphics =" + result.hashCode() + " srcImage=@" + this.hashCode());
        }
        this.graphics = result;
        return result;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isMutable() {
        return false;
    }

    void emuInvalidate() {
        int i2 = 1;
        while (i2 < 7) {
            this.emuValid[i2] = false;
            this.collisionData[i2] = null;
            ++i2;
        }
    }

    public void getRGB(int[] rgbData, int offset, int scanlength, int x, int y, int width, int height) {
        java.awt.Image src = this.emuImages[0];
        Object dst = null;
        if (src == null) {
            return;
        }
        int w = src.getWidth(null);
        int h2 = src.getHeight(null);
        if (cacheImageW == 0 || cacheImageW != width || cacheImageH != height) {
            cacheImage = new BufferedImage(width, height, 2);
            cacheGraphics = cacheImage.createGraphics();
            cacheImageW = width;
            cacheImageH = height;
        }
        cacheGraphics.drawImage(src, -x, -y, null);
        cacheImage.getRGB(0, 0, width, height, rgbData, offset, scanlength);
    }
}

