/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Graphics;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;

public class ImageItem
extends Item {
    public static final int LAYOUT_DEFAULT = 0;
    public static final int LAYOUT_LEFT = 1;
    public static final int LAYOUT_RIGHT = 2;
    public static final int LAYOUT_CENTER = 3;
    public static final int LAYOUT_NEWLINE_BEFORE = 256;
    public static final int LAYOUT_NEWLINE_AFTER = 512;
    private int mode;
    private Image image;
    private int layout;
    private String text;

    public ImageItem(String label, Image img, int layout, String altText) {
        this(label, img, layout, altText, 0);
    }

    public ImageItem(String label, Image image, int layout, String altText, int appearanceMode) {
        this.setLabel(label);
        this.image = image;
        this.layout = layout;
        this.text = altText;
        this.mode = appearanceMode;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image img) {
        this.image = img;
        this.emuUpdateScreen();
    }

    public String getAltText() {
        return this.text;
    }

    public void setAltText(String text) {
        this.text = text;
    }

    public int getLayout() {
        return this.layout;
    }

    public void setLayout(int layout) {
        this.layout = layout;
    }

    public int getAppearanceMode() {
        return this.mode;
    }

    int emuPaint(Graphics g2, int x, int y) {
        int hLayout = this.layout & 0xF;
        int vLayout = this.layout & 0xF0;
        switch (hLayout) {
            case 2: {
                x = Display.WIDTH - this.image.getWidth();
                break;
            }
            case 3: {
                x = (Display.WIDTH - this.image.getWidth()) / 2;
            }
        }
        int imageHeight = this.image.getHeight();
        switch (vLayout) {
            case 32: {
                y -= imageHeight;
                break;
            }
            case 48: {
                y -= imageHeight / 2;
            }
        }
        g2.drawImage(this.image.emuGetImage(0), x, y, null);
        return imageHeight + 2;
    }

    int emuGetHeight(Graphics g2) {
        return this.image.getHeight() + 2;
    }

    int emuGetYSpace(Graphics g2) {
        int imageHeight = this.image.getHeight();
        int vLayout = this.layout & 0xF0;
        int result = 1;
        switch (vLayout) {
            case 32: {
                result += imageHeight;
                break;
            }
            case 48: {
                result += imageHeight / 2;
            }
        }
        return result;
    }
}

