/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Spacer;

public class Screen
extends Displayable {
    static Rectangle tmpRect = new Rectangle();
    protected Vector items = new Vector();
    int selected = 0;
    static Font screenFont;

    public Screen() {
        this.emuCreateBridge();
        if (screenFont == null) {
            screenFont = new Font("Dialog", 0, 12);
        }
    }

    void emuPaint(Graphics g2) {
        Font oldFont = g2.getFont();
        g2.setFont(screenFont);
        g2.setColor(Color.LIGHT_GRAY);
        g2.fillRect(0, 0, Display.WIDTH, Display.HEIGHT);
        g2.setColor(Color.GRAY);
        g2.fillRect(0, 0, Display.WIDTH, 16);
        g2.fillRect(0, Display.HEIGHT - 16, Display.WIDTH, 16);
        g2.setColor(Color.BLACK);
        if (this.title != null) {
            g2.drawString(this.title, 0, 12);
        }
        if (this.leftCommand != null) {
            g2.drawString(this.leftCommand.getLabel(), 0, Display.HEIGHT - 4);
        }
        if (this.rightCommand != null) {
            Rectangle2D rect = screenFont.getStringBounds(this.rightCommand.getLabel(), new FontRenderContext(null, false, false));
            g2.drawString(this.rightCommand.getLabel(), Display.WIDTH - (int)rect.getWidth() - 1, Display.HEIGHT - 4);
        }
        g2.setClip(0, 16, Display.WIDTH, Display.HEIGHT - 16 - 16);
        this.emuPaintScreenContent(g2);
        g2.setClip(0, 0, Display.WIDTH, Display.HEIGHT);
        g2.setFont(oldFont);
    }

    void emuPaintScreenContent(Graphics g2) {
        System.out.println("Pstros: Screen: implement emuPaintContent for:" + this);
    }

    boolean emuKeyAction(int key, int keyChar, int modifiers, int action) {
        super.emuKeyAction(key, keyChar, modifiers, action);
        if (action == 0) {
            if ((this.emuKeyStates & 2) != 0) {
                this.moveSelectionUp();
            } else if ((this.emuKeyStates & 0x40) != 0) {
                this.moveSelectionDown();
            } else if ((this.emuKeyStates & 0x100) != 0) {
                this.emuFirePressed();
            }
        }
        return true;
    }

    private void moveSelectionDown() {
        int max;
        if (this.items.size() < 1) {
            return;
        }
        Object item = this.items.get(this.selected);
        boolean nextItem = true;
        if (item instanceof Item && ((Item)item).emuIsInteractive()) {
            nextItem = ((Item)item).emuMoveSelectionDown();
        }
        if (nextItem && this.selected < (max = this.items.size()) - 1) {
            ++this.selected;
            item = this.items.get(this.selected);
            if (item instanceof Spacer) {
                this.selected = this.selected < max - 1 ? ++this.selected : --this.selected;
            }
            this.emuUpdateScreen();
        }
    }

    private void moveSelectionUp() {
        if (this.items.size() < 1) {
            return;
        }
        Object item = this.items.get(this.selected);
        boolean previousItem = true;
        boolean nextIsSpacer = false;
        if (item instanceof Item) {
            if (((Item)item).emuIsInteractive()) {
                previousItem = ((Item)item).emuMoveSelectionUp();
            }
            nextIsSpacer = item instanceof Spacer;
        }
        if (previousItem && this.selected > 0) {
            --this.selected;
            item = this.items.get(this.selected);
            if (item instanceof Spacer) {
                this.selected = this.selected > 0 ? --this.selected : ++this.selected;
            }
            this.emuUpdateScreen();
        }
    }

    void emuFirePressed() {
        int max = this.items.size();
        if (max < 1 || this.selected < 0 || this.selected > max - 1) {
            return;
        }
        Object item = this.items.get(this.selected);
        if (item instanceof Item && ((Item)item).emuIsInteractive()) {
            ((Item)item).emuActionPressed();
        }
    }
}

