/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.media;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.media.DummyPlayer;
import javax.microedition.media.MediaException;
import javax.microedition.media.MidiPlayer;
import javax.microedition.media.Player;
import javax.microedition.media.SampledPlayer;
import ole.pstros.ConfigData;
import ole.pstros.MainApp;

public class Manager {
    public static final String TONE_DEVICE_LOCATOR = "device://tone";
    private static Vector players = new Vector();

    public static synchronized Player createPlayer(InputStream stream, String type) throws IOException, MediaException {
        if (ConfigData.forceMute) {
            return new DummyPlayer();
        }
        if (MainApp.verbose) {
            System.out.println("Manager.createPlayer(InputStream,..) type =" + type);
        }
        if (type.equals("audio/midi")) {
            MidiPlayer p2 = new MidiPlayer(stream);
            players.add(p2);
            return p2;
        }
        if (type.equals("audio/x-wav")) {
            SampledPlayer p3 = new SampledPlayer(stream);
            players.add(p3);
            return p3;
        }
        if (type.equals("audio/amr") && ConfigData.storeImages) {
            SampledPlayer.saveAudio(stream, ConfigData.storeImagePath, ".amr");
        }
        return new DummyPlayer();
    }

    public static synchronized Player createPlayer(String locator) throws IOException, MediaException {
        InputStream is;
        if (MainApp.verbose) {
            System.out.println("Manager.createPlayer(locator) locator=" + locator);
        }
        if ((is = Connector.openInputStream(locator)) == null) {
            return new DummyPlayer();
        }
        SampledPlayer p2 = new SampledPlayer(is);
        players.add(p2);
        return p2;
    }

    public static synchronized String[] getSupportedContentTypes(String protocol) {
        System.out.println("Manager.getSupportedContentTypes protocol=" + protocol);
        return new String[0];
    }

    public static synchronized String[] getSupportedProtocols(String content_type) {
        System.out.println("Manager.getSupportedPotocol content type=" + content_type);
        return new String[0];
    }

    public static synchronized void playTone(int note, int duration, int volume) throws MediaException {
    }

    public static synchronized void emuRemovePlayer(Player p2) {
        players.remove(p2);
    }

    public static synchronized void emuUpdatePlayers() {
        int size = players.size();
        int i2 = 0;
        while (i2 < size) {
            Player player = (Player)players.get(i2);
            player.emuUpdatePlayer();
            ++i2;
        }
    }

    public static void emuStopPlayers() {
        int size = players.size();
        int i2 = 0;
        while (i2 < size) {
            Player player = (Player)players.get(i2);
            try {
                player.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i2;
        }
    }
}

