/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.media;

import java.io.InputStream;
import javax.microedition.media.DummyPlayer;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.Line;
import javax.sound.sampled.Mixer;
import ole.pstros.MainApp;

class MidiPlayer
extends DummyPlayer {
    private Sequencer sequencer;
    private boolean initialized;
    private int loopCount;
    private int currentLoop;

    public MidiPlayer(InputStream stream) {
        if (MainApp.soundVerbose) {
            System.out.println("Player@" + this.hashCode() + " constructor");
        }
        try {
            this.sequencer = MidiSystem.getSequencer();
            if (this.sequencer == null) {
                System.out.println("MidiPlayer: no sequencer available...");
                return;
            }
            this.sequencer.open();
            Sequence seq = MidiSystem.getSequence(stream);
            this.sequencer.setSequence(seq);
            this.currentLoop = this.loopCount = 1;
            this.initialized = true;
        }
        catch (Exception e2) {
            System.out.println("Midi player:" + e2);
        }
    }

    public void startImpl() throws MediaException {
        if (this.initialized) {
            if (MainApp.verbose) {
                System.out.println("MidiPlayer.start()" + this);
            }
            this.sequencer.start();
            --this.currentLoop;
        }
    }

    public void stopImpl() throws MediaException {
        if (this.initialized) {
            this.sequencer.stop();
            this.currentLoop = this.loopCount;
        }
    }

    public void close() {
        if (this.initialized) {
            this.sequencer.close();
        }
        Manager.emuRemovePlayer(this);
        super.close();
    }

    public long getDuration() throws IllegalStateException {
        if (MainApp.soundVerbose) {
            System.out.println("Player@" + this.hashCode() + " getDuration()");
        }
        if (!this.initialized) {
            return -1L;
        }
        return this.sequencer.getMicrosecondLength();
    }

    public long getMediaTime() {
        if (MainApp.soundVerbose) {
            System.out.println("Player@" + this.hashCode() + " getMediaTime()");
        }
        if (!this.initialized) {
            return -1L;
        }
        super.getMediaTime();
        return this.sequencer.getMicrosecondPosition();
    }

    public long setMediaTime(long now) throws MediaException {
        if (!this.initialized) {
            throw new MediaException();
        }
        super.setMediaTime(now);
        this.sequencer.setMicrosecondPosition(now);
        return this.sequencer.getMicrosecondPosition();
    }

    public void setLoopCount(int count) {
        super.setLoopCount(count);
        if (MainApp.soundVerbose) {
            System.out.println("Player@" + this.hashCode() + " setLoopCount() " + count);
        }
        if (!this.initialized) {
            return;
        }
        if (MainApp.verbose) {
            System.out.println("setting loop count=" + this.loopCount + " to:" + this);
        }
        this.loopCount = count;
    }

    public void emuUpdatePlayer() {
        block9: {
            if (!this.initialized) {
                if (this.oldState != this.state && this.state == 300) {
                    this.emuReportEvent("error", null);
                    this.oldState = this.state;
                }
                return;
            }
            if (this.sequencer.isRunning()) {
                this.oldState = this.state;
                return;
            }
            if (this.state == 400) {
                try {
                    if (this.loopCount == 1 && this.currentLoop == 0) {
                        super.stop();
                        this.currentLoop = 1;
                        this.emuReportEvent("endOfMedia", null);
                        return;
                    }
                    if (this.currentLoop > 1 || this.loopCount < 0) {
                        this.emuReportEvent("endOfMedia", null);
                        this.sequencer.setMicrosecondPosition(0L);
                        this.start();
                    }
                }
                catch (Exception e2) {
                    if (!MainApp.verbose) break block9;
                    e2.printStackTrace();
                }
            }
        }
        if (this.oldState != this.state && this.state == 300) {
            this.emuReportEvent("stopped", null);
            this.oldState = this.state;
        }
    }

    public int emuSetVolumeLevel(int level) {
        super.emuSetVolumeLevel(level);
        return level;
    }

    public static void emuGetController() {
        Mixer.Info[] mInfo = AudioSystem.getMixerInfo();
        Mixer.Info curInfo = MidiPlayer.emuSelectMixerInfo(mInfo);
        if (curInfo == null) {
            return;
        }
        Mixer mixer = AudioSystem.getMixer(curInfo);
        Line.Info[] lInfo = mixer.getTargetLineInfo();
        Line.Info curLineInfo = MidiPlayer.emuSelectLineInfo(lInfo);
        if (curLineInfo == null) {
            return;
        }
        try {
            Line line = mixer.getLine(curLineInfo);
            Control[] controls = line.getControls();
            MidiPlayer.emuSelectControl(controls);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private static void emuSelectControl(Control[] controls) {
        if (controls == null) {
            return;
        }
        int i2 = 0;
        while (i2 < controls.length) {
            System.out.println("Control name=" + controls[i2].toString());
            ++i2;
        }
    }

    private static Mixer.Info emuSelectMixerInfo(Mixer.Info[] info) {
        if (info == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < info.length) {
            System.out.println("Mixer.Info name=" + info[i2].getName() + " desc=" + info[i2].getDescription() + " vendor=" + info[i2].getVendor());
            ++i2;
        }
        if (info.length > 1) {
            return info[1];
        }
        return null;
    }

    private static Line.Info emuSelectLineInfo(Line.Info[] info) {
        if (info == null) {
            return null;
        }
        int i2 = 0;
        while (i2 < info.length) {
            System.out.println("Line.Info =" + info[i2]);
            ++i2;
        }
        if (info.length > 0) {
            return info[0];
        }
        return null;
    }
}

