/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.media;

import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import javax.microedition.media.DummyPlayer;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import ole.pstros.MainApp;
import ole.pstros.utils.SoundConvertor;

class SampledPlayer
extends DummyPlayer
implements LineListener {
    private static int fileCounter;
    private Clip clip;
    private int loopCount;
    private int currentLoop;
    private boolean initialized;
    static /* synthetic */ Class class$0;

    public SampledPlayer(InputStream stream) {
        if (MainApp.soundVerbose) {
            System.out.println("Player@" + this.hashCode() + " constructor");
        }
        try {
            InputStream convertedStream = SoundConvertor.convertData(stream);
            try {
                DataLine.Info info;
                Class<?> clazz;
                AudioInputStream ais = AudioSystem.getAudioInputStream(convertedStream);
                AudioFormat format = ais.getFormat();
                boolean mp3active = false;
                if (format.getClass().getName().indexOf("MpegAudioFormat") > 0) {
                    AudioFormat decodedFormat;
                    mp3active = true;
                    format = decodedFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), 16, format.getChannels(), format.getChannels() * 2, format.getSampleRate(), false);
                    ais = AudioSystem.getAudioInputStream(format, ais);
                }
                if ((clazz = class$0) == null) {
                    try {
                        clazz = class$0 = Class.forName("javax.sound.sampled.Clip");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!AudioSystem.isLineSupported(info = new DataLine.Info(clazz, format))) {
                    System.out.println("Error: SapmledPlayer: input data not supported! " + format.getEncoding());
                    return;
                }
                this.clip = (Clip)AudioSystem.getLine(info);
                if (!mp3active) {
                    ais.reset();
                }
                this.clip.open(ais);
            }
            catch (LineUnavailableException ex) {
                System.out.println("Error: SapmledPlayer: " + ex);
                ex.printStackTrace();
            }
            this.currentLoop = this.loopCount = 1;
            this.initialized = true;
            this.clip.addLineListener(this);
            this.clip.setFramePosition(0);
        }
        catch (Exception e2) {
            System.out.println("Sampled player:" + e2);
            e2.printStackTrace();
        }
    }

    public static void saveAudio(InputStream is, String path, String extension) {
        DataInputStream dis = new DataInputStream(is);
        try {
            int size = dis.available();
            byte[] data = new byte[size];
            dis.readFully(data);
            FileOutputStream fos = new FileOutputStream(String.valueOf(path) + "sample" + Integer.toString(fileCounter) + extension);
            ++fileCounter;
            fos.write(data);
            fos.flush();
            fos.close();
        }
        catch (Exception e2) {
            System.out.println(e2);
            e2.printStackTrace();
        }
    }

    public void start() throws MediaException {
        super.start();
        if (this.initialized) {
            this.clip.start();
            --this.currentLoop;
        }
    }

    public void stop() throws MediaException {
        super.stop();
        if (this.initialized) {
            this.clip.stop();
            this.currentLoop = this.loopCount;
        }
    }

    public void close() {
        super.close();
        if (this.initialized) {
            this.clip.close();
        }
        this.clip.addLineListener(this);
        Manager.emuRemovePlayer(this);
    }

    public long getDuration() throws IllegalStateException {
        if (MainApp.soundVerbose) {
            System.out.println("Player@" + this.hashCode() + " getDuration()");
        }
        if (!this.initialized) {
            return -1L;
        }
        return this.clip.getMicrosecondLength();
    }

    public long getMediaTime() {
        if (MainApp.soundVerbose) {
            System.out.println("Player@" + this.hashCode() + " getMediaTime()");
        }
        if (!this.initialized) {
            return -1L;
        }
        return this.clip.getMicrosecondPosition();
    }

    public long setMediaTime(long now) throws MediaException {
        if (MainApp.soundVerbose) {
            System.out.println("Player@" + this.hashCode() + " setMediaTime() " + now);
        }
        if (!this.initialized) {
            return -1L;
        }
        this.clip.setMicrosecondPosition(now);
        return now;
    }

    public void setLoopCount(int count) {
        if (MainApp.soundVerbose) {
            System.out.println("Player@" + this.hashCode() + " setLoopCount() " + count);
        }
        if (!this.initialized) {
            return;
        }
        super.setLoopCount(count);
        this.loopCount = count;
    }

    public void emuUpdatePlayer() {
        if (this.clip.isRunning()) {
            this.oldState = this.state;
            return;
        }
        if (this.state == 400) {
            this.update(new LineEvent(this.clip, LineEvent.Type.STOP, 0L));
        }
    }

    public void update(LineEvent event) {
        if (event.getType() == LineEvent.Type.STOP && this.state == 400) {
            try {
                if (this.loopCount == 1 && this.currentLoop == 0) {
                    super.stop();
                    this.currentLoop = 1;
                    this.clip.stop();
                    this.clip.setFramePosition(0);
                    this.emuReportEvent("endOfMedia", null);
                    return;
                }
                if (this.currentLoop > 1 || this.loopCount < 0) {
                    this.emuReportEvent("endOfMedia", null);
                    this.clip.stop();
                    this.clip.setFramePosition(0);
                    this.start();
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }
}

