/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.file.FileConnection;
import ole.pstros.io.StarFilenameFilter;

public class FileConnectionImpl
implements FileConnection {
    private File file;
    private int mode;
    private String name;
    private InputStream is;
    private OutputStream os;

    public FileConnectionImpl(String localName, String name, int mode) {
        this.name = name;
        this.mode = mode;
        this.file = new File(localName);
        if (this.file.isDirectory() && !name.endsWith("/")) {
            name = String.valueOf(name) + "/";
        }
    }

    public long availableSize() {
        return 0L;
    }

    public boolean canRead() {
        if (this.file == null) {
            return false;
        }
        return this.file.canRead();
    }

    public boolean canWrite() {
        if (this.file == null) {
            return false;
        }
        return this.file.canWrite();
    }

    public void create() throws IOException {
        this.file.createNewFile();
    }

    public void delete() throws IOException {
        this.file.delete();
    }

    public long directorySize(boolean flag) throws IOException {
        return 0L;
    }

    public boolean exists() {
        if (this.file == null) {
            return false;
        }
        return this.file.exists();
    }

    public long fileSize() throws IOException {
        return this.file.length();
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.name;
    }

    public String getURL() {
        return this.name;
    }

    public boolean isDirectory() {
        if (this.file == null) {
            return false;
        }
        return this.file.isDirectory();
    }

    public boolean isHidden() {
        if (this.file == null) {
            return false;
        }
        return this.file.isHidden();
    }

    public boolean isOpen() {
        return false;
    }

    public long lastModified() {
        if (this.file == null) {
            return 0L;
        }
        return this.file.lastModified();
    }

    public Enumeration list() throws IOException {
        return this.list("*", true);
    }

    public Enumeration list(String s2, boolean flag) throws IOException {
        File[] files = this.file.listFiles(new StarFilenameFilter(s2));
        if (files == null) {
            return null;
        }
        Vector<String> v = new Vector<String>();
        int i2 = 0;
        while (i2 < files.length) {
            v.addElement(String.valueOf(files[i2].getName()) + (files[i2].isDirectory() ? "/" : ""));
            ++i2;
        }
        return v.elements();
    }

    public void setFileConnection(String path) throws IOException {
        this.name = String.valueOf(this.name) + path;
        this.file = new File(this.file, path);
        if (this.file.isDirectory() && !this.name.endsWith("/")) {
            this.name = String.valueOf(this.name) + "/";
        }
    }

    public void mkdir() throws IOException {
        this.file.mkdir();
    }

    public DataInputStream openDataInputStream() throws IOException {
        DataInputStream dis = new DataInputStream(this.openInputStream());
        this.is = dis;
        return dis;
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        DataOutputStream dos = new DataOutputStream(this.openOutputStream());
        this.os = dos;
        return dos;
    }

    public InputStream openInputStream() throws IOException {
        this.is = new BufferedInputStream(new FileInputStream(this.file));
        return this.is;
    }

    public OutputStream openOutputStream() throws IOException {
        this.os = new BufferedOutputStream(new FileOutputStream(this.file));
        return this.os;
    }

    public OutputStream openOutputStream(long l2) throws IOException {
        this.os = new FileOutputStream(this.file);
        return this.os;
    }

    public void rename(String s2) throws IOException {
    }

    public void setHidden(boolean flag) throws IOException {
    }

    public void setReadable(boolean flag) throws IOException {
    }

    public void setWritable(boolean flag) throws IOException {
    }

    public long totalSize() {
        if (this.file == null) {
            return 0L;
        }
        return this.file.length();
    }

    public void truncate(long l2) throws IOException {
    }

    public long usedSize() {
        return 0L;
    }

    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
        if (this.os != null) {
            this.os.close();
        }
    }
}

