/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.StringTokenizer;
import javax.microedition.io.Connection;
import ole.pstros.io.ConnectionProvider;
import ole.pstros.io.FileConnectionImpl;

public class FileConnectionProvider
implements ConnectionProvider {
    private static final String SCHEME = "file";
    private String[] drives;
    private String[] paths;
    private int size;
    private boolean init;

    public boolean init(String param) {
        if (param == null) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(param, ";");
        this.size = st.countTokens();
        if (this.size < 2) {
            this.size = 0;
            return false;
        }
        this.size /= 2;
        this.drives = new String[this.size];
        this.paths = new String[this.size];
        int i2 = 0;
        while (i2 < this.size) {
            this.drives[i2] = st.nextToken();
            this.paths[i2] = st.nextToken();
            ++i2;
        }
        this.init = true;
        return true;
    }

    public String getScheme() {
        return SCHEME;
    }

    public Connection open(String name, int mode, boolean timeouts) throws IOException {
        String localName = this.remapFileName(name);
        return new FileConnectionImpl(localName, name, mode);
    }

    public DataInputStream openDataInputStream(String name) throws IOException {
        String localName = this.remapFileName(name);
        FileConnectionImpl fc = new FileConnectionImpl(localName, name, 1);
        return fc.openDataInputStream();
    }

    public DataOutputStream openDataOutputStream(String name) throws IOException {
        String localName = this.remapFileName(name);
        FileConnectionImpl fc = new FileConnectionImpl(localName, name, 2);
        return fc.openDataOutputStream();
    }

    public InputStream openInputStream(String name) throws IOException {
        String localName = this.remapFileName(name);
        FileConnectionImpl fc = new FileConnectionImpl(localName, name, 1);
        return fc.openInputStream();
    }

    public OutputStream openOutputStream(String name) throws IOException {
        String localName = this.remapFileName(name);
        FileConnectionImpl fc = new FileConnectionImpl(localName, name, 2);
        return fc.openOutputStream();
    }

    private String remapFileName(String name) throws IOException {
        int i2 = 0;
        while (i2 < this.size) {
            int index = name.indexOf(this.drives[i2]);
            if (index > 0) {
                return String.valueOf(this.paths[i2]) + name.substring(index += this.drives[i2].length());
            }
            ++i2;
        }
        throw new IOException("mapping not found for filename=" + name);
    }

    public String[] getRoots() {
        return this.drives;
    }
}

