/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.io;

import java.io.File;
import java.io.FilenameFilter;

public class StarFilenameFilter
implements FilenameFilter {
    private boolean starts;
    private boolean ends;
    private boolean contains;
    private String startString;
    private String endString;
    private String containString;

    public StarFilenameFilter(String pattern) {
        if (pattern.equals("*")) {
            return;
        }
        if (pattern.startsWith("*") && pattern.endsWith("*") && pattern.length() > 2) {
            this.contains = true;
            this.containString = pattern.substring(1, pattern.length() - 1);
            return;
        }
        if (pattern.startsWith("*")) {
            this.ends = true;
            this.endString = pattern.substring(1);
        }
        if (pattern.endsWith("*")) {
            this.starts = true;
            this.startString = pattern.substring(0, pattern.length() - 1);
        }
    }

    public boolean accept(File dir, String name) {
        if (this.starts && !name.startsWith(this.startString)) {
            return false;
        }
        if (this.ends && !name.endsWith(this.endString)) {
            return false;
        }
        return !this.contains || name.indexOf(this.containString) >= 0;
    }
}

