/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.monitor;

import java.util.Vector;
import ole.pstros.monitor.ClassMonitor;
import ole.pstros.monitor.MonitorProfile;
import ole.pstros.utils.ListItem;

public class ClassManager {
    private static final boolean DEBUG = false;
    public static final String DEFAULT_PROFILE_NAME = "--Default--";
    private static ClassManager instance;
    private Vector monitors = new Vector();
    private int latestItemCount;
    private Vector profiles = new Vector();
    private MonitorProfile currentProfile = new MonitorProfile("--Default--");

    public static ClassManager getInstance() {
        if (instance == null) {
            instance = new ClassManager();
        }
        return instance;
    }

    private ClassManager() {
        this.profiles.add(this.currentProfile);
        this.currentProfile = null;
    }

    public void addClass(Class cl) {
        ClassMonitor cm = new ClassMonitor(cl);
        this.monitors.add(cm);
    }

    private MonitorProfile getProfile(String profileName) {
        int size = this.profiles.size();
        int i2 = 0;
        while (i2 < size) {
            MonitorProfile profile = (MonitorProfile)this.profiles.get(i2);
            if (profileName.equals(profile.getName())) {
                return profile;
            }
            ++i2;
        }
        return null;
    }

    public void addVariable(String variableName, String profileName) {
        MonitorProfile profile;
        if (profileName == null) {
            profileName = DEFAULT_PROFILE_NAME;
        }
        if ((profile = this.getProfile(profileName)) == null) {
            profile = new MonitorProfile(profileName);
            this.profiles.add(profile);
        }
        profile.addItem(variableName);
    }

    public void deleteVariable(String variableName, String profileName) {
        if (profileName == null) {
            profileName = DEFAULT_PROFILE_NAME;
        }
        MonitorProfile profile = this.getProfile(profileName);
        profile.deleteItem(variableName);
    }

    public String getCurrentProfileName() {
        if (this.currentProfile == null) {
            return DEFAULT_PROFILE_NAME;
        }
        return this.currentProfile.getName();
    }

    public void invalidateCurrentProfile() {
        this.currentProfile = null;
    }

    public String[] getProfileNames() {
        int size = this.profiles.size();
        String[] result = new String[size];
        int i2 = 0;
        while (i2 < size) {
            result[i2] = ((MonitorProfile)this.profiles.get(i2)).getName();
            ++i2;
        }
        return result;
    }

    public MonitorProfile[] getProfiles() {
        int size = this.profiles.size();
        MonitorProfile[] result = new MonitorProfile[size];
        int i2 = 0;
        while (i2 < size) {
            result[i2] = (MonitorProfile)this.profiles.get(i2);
            ++i2;
        }
        return result;
    }

    public void setProfile(String profileName, Object objectRoot) {
        MonitorProfile profile;
        if (profileName == null) {
            profileName = DEFAULT_PROFILE_NAME;
        }
        if ((profile = this.getProfile(profileName)) == null) {
            profileName = DEFAULT_PROFILE_NAME;
            profile = this.getProfile(profileName);
        }
        if (this.currentProfile == profile) {
            return;
        }
        this.cleanWatchedVariables();
        this.currentProfile = profile;
        int size = this.monitors.size();
        Class<?> objectClass = null;
        ListItem[] result = null;
        if (objectRoot == null) {
            return;
        }
        objectClass = objectRoot.getClass();
        ClassMonitor cm = this.getClassMonitor(objectClass);
        if (cm != null) {
            int profileSize = profile.getSize();
            int j2 = 0;
            while (j2 < profileSize) {
                cm.addWatchedVariable(profile.getItem(j2), 0);
                ++j2;
            }
        }
    }

    private void cleanWatchedVariables() {
        int size = this.monitors.size();
        int i2 = 0;
        while (i2 < size) {
            ClassMonitor cm = (ClassMonitor)this.monitors.get(i2);
            cm.cleanWatchedVariables();
            ++i2;
        }
    }

    public ListItem[] getItems(Object object) {
        int size = this.monitors.size();
        Class<?> objectClass = null;
        ListItem[] result = null;
        if (object != null) {
            objectClass = object.getClass();
        }
        int i2 = 0;
        while (i2 < size) {
            ClassMonitor cm = (ClassMonitor)this.monitors.get(i2);
            if (object != null && objectClass == cm.getBaseClass() || object == null) {
                result = cm.getVariables(object);
                this.latestItemCount = cm.getVariableCount();
            }
            ++i2;
        }
        return result;
    }

    public int getItemCount() {
        return this.latestItemCount;
    }

    public ClassMonitor getClassMonitor(Class cl) {
        ClassMonitor cm;
        int size = this.monitors.size();
        if (cl.isArray()) {
            cl = cl.getComponentType();
        }
        int i2 = 0;
        while (i2 < size) {
            cm = (ClassMonitor)this.monitors.get(i2);
            if (cm.getBaseClass() == cl) {
                return cm;
            }
            ++i2;
        }
        cm = new ClassMonitor(cl);
        this.monitors.add(cm);
        return cm;
    }
}

