/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.rms;

import java.io.File;
import java.util.Vector;
import ole.pstros.ConfigData;
import ole.pstros.rms.RmsGroup;
import ole.pstros.utils.XmlTag;
import ole.pstros.utils.XmlWriter;

public class RmsManager {
    public static final String PUBLIC_STORAGE = "--==PUBLIC_STORAGE==--";
    private static RmsManager instance;
    private Vector groups = new Vector();

    public static RmsManager getInstance() {
        if (instance == null) {
            instance = new RmsManager();
        }
        return instance;
    }

    private RmsManager() {
    }

    public RmsGroup getRmsGroup(String appName, String groupName, boolean authPublic, boolean create) {
        RmsGroup group = this.findGroup(appName, groupName);
        if (group == null && create) {
            group = new RmsGroup(appName, groupName);
            group.setAuthMode(authPublic);
            this.groups.add(group);
        } else if (group != null && group.isPrivate() && authPublic) {
            group = null;
        }
        return group;
    }

    public boolean removeGroup(String appName, String groupName) {
        RmsGroup group = this.findGroup(appName, groupName);
        if (group != null) {
            return this.groups.remove(group);
        }
        return false;
    }

    public String[] getGroupNames(String appName) {
        RmsGroup group;
        int size = this.groups.size();
        int count = 0;
        int i2 = 0;
        while (i2 < size) {
            group = (RmsGroup)this.groups.get(i2);
            if (group.getApplicationName().equals(appName)) {
                ++count;
            }
            ++i2;
        }
        if (count == 0) {
            return null;
        }
        String[] result = new String[count];
        count = 0;
        int i3 = 0;
        while (i3 < size) {
            group = (RmsGroup)this.groups.get(i3);
            if (group.getApplicationName().equals(appName)) {
                result[count] = group.getName();
                ++count;
            }
            ++i3;
        }
        return result;
    }

    private RmsGroup findGroup(String appName, String groupName) {
        int size = this.groups.size();
        int i2 = 0;
        while (i2 < size) {
            RmsGroup group = (RmsGroup)this.groups.get(i2);
            if (group.getApplicationName().equals(appName) && group.getName().equals(groupName)) {
                return group;
            }
            ++i2;
        }
        return null;
    }

    public void saveData() {
        if (ConfigData.readOnly) {
            return;
        }
        File file = new File(this.getDataFilename());
        XmlWriter writer = new XmlWriter(file);
        XmlTag tag = new XmlTag();
        writer.startTag("rms");
        int size = this.groups.size();
        int i2 = 0;
        while (i2 < size) {
            RmsGroup group = (RmsGroup)this.groups.get(i2);
            int groupSize = group.getSize();
            if (groupSize > 0) {
                tag.setName("record");
                tag.setEndTagType(1);
                tag.setProperty("application", group.getApplicationName());
                tag.setProperty("name", group.getName());
                if (group.isPublic()) {
                    tag.setProperty("auth", 1);
                }
                int j2 = 0;
                while (j2 < groupSize) {
                    byte[] data = group.getRecordData(j2 + 1);
                    if (data != null && data.length > 0) {
                        tag.setProperty("data" + j2, this.toHex(data));
                    }
                    ++j2;
                }
                writer.startTag(tag);
            }
            ++i2;
        }
        writer.endTag("rms");
        try {
            writer.close();
        }
        catch (Exception e2) {
            System.out.println("Pstros: RmsManager: can't write rms file! " + file.getAbsolutePath());
            e2.printStackTrace();
        }
    }

    private String toHex(byte[] data) {
        int size = data.length;
        StringBuffer result = new StringBuffer();
        int i2 = 0;
        while (i2 < size) {
            result.append(Integer.toString(data[i2])).append(' ');
            ++i2;
        }
        return result.toString();
    }

    public String getDataFilename() {
        String dir = System.getProperty("user.home");
        File dirFile = new File(dir = String.valueOf(dir) + "/.pstros");
        if (!dirFile.exists()) {
            dirFile.mkdir();
        }
        if (ConfigData.deviceName == null) {
            return String.valueOf(dir) + "/rms.xml";
        }
        return String.valueOf(dir) + "/rms_" + ConfigData.deviceName + ".xml";
    }
}

