/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import ole.pstros.ConfigData;
import ole.pstros.MainApp;
import ole.pstros.utils.BaseUrlFactory;

public abstract class BaseClassLoader
extends ClassLoader {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    static BaseClassLoader instance;

    public BaseClassLoader() {
        instance = this;
    }

    public BaseClassLoader(ClassLoader masterCl) {
        super(masterCl);
        instance = this;
        URL.setURLStreamHandlerFactory(new BaseUrlFactory(this));
    }

    public InputStream getResourceAsStream(String name) {
        byte[] data;
        if (MainApp.verbose) {
            System.out.println("JCL: getResource as stream=" + name);
        }
        if ((data = this.loadData(name)) != null) {
            this.delayRead(data);
            return new ByteArrayInputStream(data);
        }
        return super.getResourceAsStream(name);
    }

    public static InputStream getSystemResourceAsStream(String name) {
        byte[] data;
        if (MainApp.verbose) {
            System.out.println("JCL: getSystemResource as stream=" + name);
        }
        if ((data = instance.loadData(name)) != null) {
            instance.delayRead(data);
            return new ByteArrayInputStream(data);
        }
        return ClassLoader.getSystemResourceAsStream(name);
    }

    public byte[] getResourceAsByteArray(String name) {
        byte[] data;
        if (MainApp.verbose) {
            System.out.println("JCL: getResource as byte array=" + name);
        }
        if (name.startsWith("/")) {
            name = name.substring(1, name.length());
        }
        if ((data = this.loadData(name)) != null) {
            this.delayRead(data);
        }
        return data;
    }

    private void delayRead(byte[] data) {
        if (ConfigData.readSpeed > 0) {
            try {
                int sleepVal = ConfigData.readSpeed * data.length / 1024;
                if (sleepVal > 0) {
                    Thread.sleep(sleepVal);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        byte[] data;
        if (MainApp.verbose) {
            System.out.println("BaseClassLoader: findClass=" + name);
        }
        Class<?> result = null;
        String loadName = name.replace('.', '/');
        if (!loadName.endsWith(".class")) {
            loadName = String.valueOf(loadName) + ".class";
        }
        result = (data = this.loadData(loadName)) != null ? this.defineClass(name, data, 0, data.length) : super.findClass(name);
        return result;
    }

    protected abstract byte[] loadData(String var1);

    protected void dumpByteArray(byte[] data) {
        int size = data.length;
        System.out.println("------ size=" + size + " -----");
        int i2 = 0;
        while (i2 < size) {
            int b2 = data[i2];
            if (b2 < 0) {
                b2 += 256;
            }
            this.dumpByte(b2, i2);
            ++i2;
        }
        System.out.println();
    }

    protected void dumpByte(int b2, int index) {
        if (index % 16 == 0) {
            System.out.print(HEX[index >> 12 & 0xF]);
            System.out.print(HEX[index >> 8 & 0xF]);
            System.out.print(HEX[index >> 4 & 0xF]);
            System.out.print(String.valueOf(HEX[index & 0xF]) + "  | ");
        }
        System.out.print(HEX[b2 >> 4]);
        System.out.print(String.valueOf(HEX[b2 & 0xF]) + " ");
        if (index % 16 == 15) {
            System.out.println();
        }
    }

    public URL getResource(String name) {
        System.out.println("Pstros BaseClassLoader: getResource called name=" + name);
        return null;
    }

    protected URL findResource(String name) {
        System.out.println("Pstros BaseClassLoader: findResource called name=" + name);
        return null;
    }
}

