/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.awt.Image;
import java.io.File;
import java.io.FileReader;
import java.io.LineNumberReader;
import javax.microedition.lcdui.Display;
import javax.swing.ImageIcon;
import ole.pstros.ConfigData;
import ole.pstros.MainApp;
import ole.pstros.utils.JadFileParser;

public class ConfigLoader {
    private static final String KEY_LEFT_SOFT = "device.keyLeftSoft";
    private static final String KEY_RIGHT_SOFT = "device.keyRightSoft";
    private static final String KEY_MENU_SOFT = "device.keyMenuSoft";
    private static final String KEY_CENTER_SOFT = "device.keyCenterSoft";
    private static final String KEY_SEND = "device.keySend";
    private static final String KEY_END = "device.keyEnd";
    private static final String KEY_SHIFT = "device.keyShift";
    private static final String KEY_UP_ARROW = "device.keyUpArrow";
    private static final String KEY_DOWN_ARROW = "device.keyDownArrow";
    private static final String KEY_LEFT_ARROW = "device.keyLeftArrow";
    private static final String KEY_RIGHT_ARROW = "device.keyRightArrow";
    private static final String KEY_SELECT = "device.keySelect";
    private static final String KEY_BACK = "device.keyBack";
    private static final String KEY_CLEAR = "device.keyClear";
    private static final String KEY_PLUS = "device.keyPlus";
    private static final String CALL_EVENT = "device.callEvent";
    private static final String READ_SPEED = "device.readSpeed";
    private static final String SCREEN_HEIGHT = "device.height";
    private static final String SCREEN_WIDTH = "device.width";
    private static final String VIDEO_MEMORY = "device.videoMemory";
    private static final String SCREEN_ROT_HEIGHT = "device.rotatedHeight";
    private static final String SCREEN_ROT_WIDTH = "device.rotatedWidth";
    private static final String TOP_CONSOLE_HEIGHT = "device.topConsoleHeight";
    private static final String BOTTOM_CONSOLE_HEIGHT = "device.bottomConsoleHeight";
    private static final String SKIN_SCREEN_X = "skin.screenX";
    private static final String SKIN_SCREEN_Y = "skin.screenY";
    private static final String SKIN_IMAGE_NEUTRAL = "skin.imageNeutral";
    private static int changeCounter;
    private static String configPath;
    private static int screenHeight;

    static {
        screenHeight = -1;
    }

    public static void readConfig(String fileName) {
        String line = ".";
        changeCounter = 0;
        System.out.println("Config loader: readConfig name=" + fileName);
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                System.out.println("Error:ConfigLoader: file not exist, file=" + fileName);
                return;
            }
            configPath = file.getParent();
            FileReader fileReader = new FileReader(file);
            LineNumberReader reader = new LineNumberReader(fileReader);
            while (line != null) {
                line = reader.readLine();
                if (line == null) continue;
                ConfigLoader.parseLine(line);
            }
            if (changeCounter > 0) {
                ConfigData.configActive = true;
            }
            ConfigLoader.setScreenHeight();
        }
        catch (Exception e2) {
            System.out.println("Error:ConfigLoader:" + e2);
            e2.printStackTrace();
        }
    }

    public static void parseLine(String line) {
        if (line.startsWith(KEY_LEFT_SOFT)) {
            ConfigData.keyLeftSoft = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(KEY_RIGHT_SOFT)) {
            ConfigData.keyRightSoft = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(KEY_CENTER_SOFT)) {
            ConfigData.keyCenterSoft = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(KEY_UP_ARROW)) {
            ConfigData.keyUpArrow = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(KEY_DOWN_ARROW)) {
            ConfigData.keyDownArrow = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(KEY_LEFT_ARROW)) {
            ConfigData.keyLeftArrow = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(KEY_RIGHT_ARROW)) {
            ConfigData.keyRightArrow = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(KEY_SELECT)) {
            ConfigData.keySelect = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(KEY_BACK)) {
            ConfigData.keyBack = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(KEY_CLEAR)) {
            ConfigData.keyClear = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(TOP_CONSOLE_HEIGHT)) {
            ConfigData.topConsoleHeight = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(BOTTOM_CONSOLE_HEIGHT)) {
            ConfigData.bottomConsoleHeight = ConfigLoader.getIntValue(line);
            ConfigData.fullScreenSupported = false;
        } else if (line.startsWith(VIDEO_MEMORY)) {
            ConfigData.videoMemoryLimit = ConfigLoader.getIntValue(line);
            ConfigData.videoMemoryLimit = ConfigData.videoMemoryLimit < 0 ? 0x100000 : (ConfigData.videoMemoryLimit <<= 10);
        } else if (line.startsWith(CALL_EVENT)) {
            int index = line.indexOf(61);
            if (index < 0) {
                index = line.indexOf(58);
            }
            ConfigData.callEvent = JadFileParser.cleanValue(line.substring(index + 1));
        } else if (line.startsWith(READ_SPEED)) {
            ConfigData.readSpeed = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(SKIN_SCREEN_X)) {
            ConfigData.skinScreenX = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(SKIN_SCREEN_Y)) {
            ConfigData.skinScreenY = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(SCREEN_WIDTH)) {
            Display.WIDTH = ConfigLoader.getIntValue(line);
            if (ConfigData.originalScreenWidth > 0) {
                ConfigData.originalScreenWidth = Display.WIDTH;
            }
        } else if (line.startsWith(SCREEN_HEIGHT)) {
            screenHeight = ConfigLoader.getIntValue(line);
        } else if (line.startsWith(SCREEN_ROT_WIDTH)) {
            ConfigData.rotatedScreenWidth = ConfigLoader.getIntValue(line);
            if (ConfigData.rotatedScreenHeight < 0) {
                ConfigData.rotatedScreenHeight = Display.WIDTH;
            }
            ConfigData.originalScreenWidth = Display.WIDTH;
            ConfigData.originalScreenHeight = Display.HEIGHT;
        } else if (line.startsWith(SCREEN_ROT_HEIGHT)) {
            ConfigData.rotatedScreenHeight = ConfigLoader.getIntValue(line);
            if (ConfigData.rotatedScreenWidth < 0) {
                ConfigData.rotatedScreenWidth = Display.HEIGHT;
            }
            ConfigData.originalScreenWidth = Display.WIDTH;
            ConfigData.originalScreenHeight = Display.HEIGHT;
        } else if (line.startsWith(SKIN_IMAGE_NEUTRAL)) {
            String value = JadFileParser.getLineValue(line, 1);
            value = JadFileParser.cleanValue(value);
            Image image = ConfigLoader.readImage(String.valueOf(configPath) + "/" + value);
            if (image != null) {
                ++changeCounter;
                ConfigData.skinImage = image;
                ConfigData.skinWidth = image.getWidth(null);
                ConfigData.skinHeight = image.getHeight(null);
            }
        }
    }

    public static void setScreenHeight() {
        if (screenHeight < 0) {
            screenHeight = Display.HEIGHT;
        }
        Display.HEIGHT = screenHeight + ConfigData.bottomConsoleHeight + ConfigData.topConsoleHeight;
        if (ConfigData.originalScreenHeight > 0) {
            ConfigData.originalScreenHeight = Display.HEIGHT;
            ConfigData.rotatedScreenHeight += ConfigData.bottomConsoleHeight;
        }
        if (MainApp.verbose) {
            System.out.println("Setting Display.HEIGHT=" + Display.HEIGHT);
        }
    }

    public static int getIntValue(String line) {
        ++changeCounter;
        String value = JadFileParser.getLineValue(line, 1);
        if ((value = JadFileParser.cleanValue(value)) == null || value.length() < 1) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public static String getStringValue(String line) {
        ++changeCounter;
        String value = JadFileParser.getLineValue(line, 1);
        if ((value = JadFileParser.cleanValue(value)) == null || value.length() < 1) {
            return null;
        }
        return value;
    }

    private static Image readImage(String fileName) {
        ImageIcon ii = new ImageIcon(fileName);
        if (ii == null) {
            return null;
        }
        return ii.getImage();
    }
}

