/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.io.IOException;
import java.io.InputStream;

public class FrameInputStream
extends InputStream {
    byte[] data;
    int frameSize;
    int position;
    int markPosition;
    boolean fixResetBug;
    int resetCount;

    public FrameInputStream(byte[] data, int frameSize, boolean fixResetBug) {
        this.data = data;
        this.frameSize = frameSize;
        this.fixResetBug = fixResetBug;
    }

    public int available() throws IOException {
        int rest = this.data.length - this.position;
        if (rest > this.frameSize) {
            rest = this.frameSize;
        }
        return rest;
    }

    public void close() throws IOException {
        this.data = null;
    }

    public synchronized void mark(int readlimit) {
        this.markPosition = this.position;
    }

    public boolean markSupported() {
        return true;
    }

    public int read() throws IOException {
        if (this.position >= this.data.length) {
            return -1;
        }
        int result = this.data[this.position] & 0xFF;
        ++this.position;
        return result;
    }

    public int read(byte[] b2, int off, int len) throws IOException {
        int size;
        int n2 = size = len > this.frameSize ? this.frameSize : len;
        if (this.position + len > this.data.length) {
            size = this.data.length - this.position;
        }
        System.arraycopy(this.data, this.position, b2, off, size);
        this.position += size;
        System.out.println("read b[], off=" + off + " len=" + len + " size=" + size + " position=" + this.position + " data size=" + this.data.length);
        return size;
    }

    public int read(byte[] b2) throws IOException {
        int size = b2.length > this.frameSize ? this.frameSize : b2.length;
        System.arraycopy(this.data, this.position, b2, 0, size);
        this.position += size;
        return size;
    }

    public synchronized void reset() throws IOException {
        this.position = this.fixResetBug && this.resetCount == 0 ? 44 : this.markPosition;
        ++this.resetCount;
    }

    public long skip(long n2) throws IOException {
        int oldPos = this.position;
        this.position = (int)((long)this.position + n2);
        if (this.position > this.data.length) {
            this.position = this.data.length;
            int result = this.position - oldPos;
            if (result == 0) {
                return -1L;
            }
            return result;
        }
        return n2;
    }
}

