/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import ole.pstros.utils.WaveConvertor;

public class ImaConvertor
extends WaveConvertor {
    private static final int ISSTMAX = 88;
    private static final int[] imaStepSizeTable = new int[]{7, 8, 9, 10, 11, 12, 13, 14, 16, 17, 19, 21, 23, 25, 28, 31, 34, 37, 41, 45, 50, 55, 60, 66, 73, 80, 88, 97, 107, 118, 130, 143, 157, 173, 190, 209, 230, 253, 279, 307, 337, 371, 408, 449, 494, 544, 598, 658, 724, 796, 876, 963, 1060, 1166, 1282, 1411, 1552, 1707, 1878, 2066, 2272, 2499, 2749, 3024, 3327, 3660, 4026, 4428, 4871, 5358, 5894, 6484, 7132, 7845, 8630, 9493, 10442, 11487, 12635, 13899, 15289, 16818, 18500, 20350, 22385, 24623, 27086, 29794, Short.MAX_VALUE};
    private static int[][] imaStateAdjustTable = new int[89][8];

    private static final int imaStateAdjust(int c2) {
        return c2 < 4 ? -1 : 2 * c2 - 6;
    }

    private static void initImaTable() {
        int i2 = 0;
        while (i2 <= 88) {
            int j2 = 0;
            while (j2 < 8) {
                int k2 = i2 + ImaConvertor.imaStateAdjust(j2);
                if (k2 < 0) {
                    k2 = 0;
                } else if (k2 > 88) {
                    k2 = 88;
                }
                ImaConvertor.imaStateAdjustTable[i2][j2] = k2;
                ++j2;
            }
            ++i2;
        }
    }

    private static int getUChar(byte[] arr, int i2) {
        byte b2 = arr[i2];
        return (b2 & Integer.MIN_VALUE) >>> 24 | b2 & 0x7F;
    }

    private static int imaExpandS(int ch, int chans, byte[] ibuff, int ibuffOffset, byte[] obuff, int obuffOffset, int n2, int o_inc) {
        int ip = ibuffOffset + 4 * ch;
        int i_inc = 4 * (chans - 1);
        int val = ImaConvertor.getUChar(ibuff, ip + 0) + (ImaConvertor.getUChar(ibuff, ip + 1) << 8);
        int state = ImaConvertor.getUChar(ibuff, ip + 2);
        if (state > 88) {
            System.out.println("IMA_ADPCM block ch" + ch + " initial-state " + state + " out of range");
            state = 0;
        }
        ip += 4 + i_inc;
        int op = obuffOffset;
        obuff[op] = (byte)(val >> 8 & 0xFF);
        obuff[op + 1] = (byte)(val & 0xFF);
        op += o_inc;
        int i2 = 1;
        while (i2 < n2) {
            int cm;
            if ((i2 & 1) != 0) {
                cm = ImaConvertor.getUChar(ibuff, ip) & 0xF;
            } else {
                cm = ImaConvertor.getUChar(ibuff, ip) >> 4;
                ++ip;
                if ((i2 & 7) == 0) {
                    ip += i_inc;
                }
            }
            int step = imaStepSizeTable[state];
            int c2 = cm & 7;
            state = imaStateAdjustTable[state][c2];
            int dp = (c2 + c2 + 1) * step >> 3;
            if (c2 != cm) {
                if ((val -= dp) < Short.MIN_VALUE) {
                    val = Short.MIN_VALUE;
                }
            } else if ((val += dp) > Short.MAX_VALUE) {
                val = Short.MAX_VALUE;
            }
            obuff[op] = (byte)(val >> 8 & 0xFF);
            obuff[op + 1] = (byte)(val & 0xFF);
            op += o_inc;
            ++i2;
        }
        return op - obuffOffset;
    }

    public static int imaSamplesIn(int dataLen, int chans, int blockAlign, int samplesPerBlock) {
        int m2;
        int n2;
        if (samplesPerBlock != 0) {
            n2 = dataLen / blockAlign * samplesPerBlock;
            m2 = dataLen % blockAlign;
        } else {
            n2 = 0;
            m2 = blockAlign;
        }
        if (m2 >= 4 * chans) {
            m2 -= 4 * chans;
            m2 /= 4 * chans;
            m2 = 8 * m2 + 1;
            if (samplesPerBlock != 0 && m2 > samplesPerBlock) {
                m2 = samplesPerBlock;
            }
            n2 += m2;
        }
        return n2;
    }

    int imaBytesPerBlock(int chans, int samplesPerBlock) {
        int n2 = (samplesPerBlock + 14) / 8 * 4 * chans;
        return n2;
    }

    public static WaveConvertor getInstance() {
        if (instance == null) {
            instance = ImaConvertor.createInstance();
        }
        return instance;
    }

    protected static WaveConvertor createInstance() {
        ImaConvertor.initImaTable();
        return new ImaConvertor();
    }

    private ImaConvertor() {
    }

    public byte[] convert(byte[] srcData, int[] dstParams) {
        int fmtIndex = this.findChunk(srcData, CHUNK_FMT, 0);
        if (fmtIndex == -1) {
            return srcData;
        }
        int chunkSize = this.getI4(srcData, fmtIndex + 4);
        int numChannels = this.getChannelCount(srcData, fmtIndex += 8);
        int freq = this.getSamplingFreq(srcData, fmtIndex);
        int bPerSec = this.getBytesPerSec(srcData, fmtIndex);
        int align = this.getBlockAlign(srcData, fmtIndex);
        int bits = this.getBitsPerSample(srcData, fmtIndex);
        int samplesPerBlock = this.getSamplesPerBlock(srcData, fmtIndex);
        int bytesPerBlock = this.imaBytesPerBlock(numChannels, samplesPerBlock);
        if (bytesPerBlock > align || samplesPerBlock % 8 != 1) {
            System.out.println("samplesPerBlock incompatible with blockAlign!  spb=" + samplesPerBlock + " ba=" + align + " bpb=" + bytesPerBlock);
            return srcData;
        }
        if (numChannels > 1) {
            System.out.println("Stereo sampled sounds? not supported...");
        }
        dstParams[0] = numChannels;
        dstParams[1] = freq;
        dstParams[2] = 2;
        int dataIndex = this.findChunk(srcData, CHUNK_DATA, fmtIndex + chunkSize);
        if (dataIndex == -1) {
            return srcData;
        }
        chunkSize = this.getI4(srcData, dataIndex + 4);
        dataIndex += 8;
        byte[] dstBuf = new byte[chunkSize / align * samplesPerBlock * 2];
        int dataSize = chunkSize;
        int dstSize = 0;
        while (dataSize > bytesPerBlock) {
            dstSize += ImaConvertor.imaExpandS(0, 1, srcData, dataIndex + (chunkSize - dataSize), dstBuf, dstSize, samplesPerBlock, 2);
            dataSize -= align;
        }
        return dstBuf;
    }
}

