/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.swing.ImageIcon;
import ole.pstros.ConfigData;
import ole.pstros.MainApp;
import ole.pstros.utils.SixlegsHelper;
import ole.pstros.utils.TgaWriter;

public class ImageCreator
implements ImageObserver {
    private static boolean ICON = true;
    private static int imgNumber;
    private int width;
    private int height;
    private boolean loadDone;
    private static int[] pixelSignatures;

    static {
        pixelSignatures = new int[4096];
    }

    public Image createImage(byte[] data) {
        if (ConfigData.storeImages) {
            ImageCreator.saveImage(data);
        }
        if (ImageCreator.isPng(data) && SixlegsHelper.isAvailable()) {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            BufferedImage image = SixlegsHelper.getImage(stream);
            if (image == null) {
                throw new IllegalArgumentException();
            }
            return image;
        }
        if (ICON) {
            ImageIcon ii = new ImageIcon(data);
            if (ii.getIconWidth() < 0 || ii.getIconHeight() < 0) {
                return null;
            }
            return ii.getImage();
        }
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image img = tk.createImage(data);
        img.getWidth(this);
        img.getHeight(this);
        while (!this.loadDone) {
            try {
                Thread.sleep(5L);
            }
            catch (Exception e2) {
                System.out.println("ImageCreator: " + e2);
            }
        }
        return img;
    }

    private static boolean isPng(byte[] data) {
        return data[1] == 80 && data[2] == 78 && data[3] == 71;
    }

    public static Image createImage(int width, int height, int colorARGB) {
        return ImageCreator.createBufferedImage(width, height, colorARGB);
    }

    public static BufferedImage createBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        int w = image.getWidth(null);
        int h2 = image.getHeight(null);
        BufferedImage result = ImageCreator.createBufferedImage(w, h2, 0);
        Graphics g2 = result.getGraphics();
        g2.drawImage(image, 0, 0, null);
        return result;
    }

    public static BufferedImage createBufferedImage(int width, int height, int colorARGB) {
        BufferedImage result = new BufferedImage(width, height, 2);
        int size = width * height;
        int[] data = new int[size];
        int i2 = 0;
        while (i2 < size) {
            data[i2] = colorARGB;
            ++i2;
        }
        result.setRGB(0, 0, width, height, data, 0, width);
        return result;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        this.width = width;
        this.height = height;
        if (infoflags != 32) {
            return true;
        }
        this.loadDone = true;
        return true;
    }

    private static void saveImage(byte[] data) {
        File file = new File(String.valueOf(ConfigData.storeImagePath) + "img" + Integer.toString(imgNumber) + ".png");
        if (MainApp.verbose) {
            System.out.println("Saving image: " + file.getAbsolutePath());
        }
        try {
            FileOutputStream stream = new FileOutputStream(file);
            stream.write(data);
            stream.flush();
            stream.close();
            ImageCreator.pixelSignatures[ImageCreator.imgNumber] = 0;
            ++imgNumber;
        }
        catch (Exception e2) {
            System.out.println("Image creator: Save image failed! " + e2);
        }
    }

    public static void saveImage(BufferedImage img) {
        String fileName = TgaWriter.saveImageTransparent(String.valueOf(ConfigData.storeImagePath) + "img", img, img.getWidth(), img.getHeight(), 0, imgNumber);
        if (fileName != null) {
            ++imgNumber;
            if (MainApp.verbose) {
                System.out.println("Saving image: " + fileName);
            }
        }
    }

    public static int savePixels(int[] pixels, int w, int h2) {
        int signature = ImageCreator.computePixelSignature(pixels, w, h2);
        int index = ImageCreator.findSignature(signature);
        if (index == -1) {
            index = imgNumber;
            ImageCreator.pixelSignatures[index] = signature;
            int size = w * h2;
            byte[] data = new byte[size * 3];
            int i2 = 0;
            while (i2 < size) {
                int pixel = pixels[i2];
                data[i2 * 3] = (byte)(pixel & 0xFF);
                data[i2 * 3 + 1] = (byte)((pixel & 0xFF00) >> 8);
                data[i2 * 3 + 2] = (byte)((pixel & 0xFF0000) >> 16);
                ++i2;
            }
            TgaWriter.setFormat((byte)24);
            TgaWriter.saveImageData(String.valueOf(ConfigData.storeImagePath) + "pixels", data, 0, data.length, w, h2, index);
            ++imgNumber;
        }
        return index;
    }

    private static int computePixelSignature(int[] pixels, int w, int h2) {
        int result = 0;
        int size = w * h2;
        int i2 = 0;
        while (i2 < size) {
            result += pixels[i2] * i2;
            ++i2;
        }
        return result |= size;
    }

    private static int findSignature(int sig) {
        int i2 = 0;
        while (i2 < imgNumber) {
            if (pixelSignatures[i2] == sig) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }
}

