/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.awt.BorderLayout;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.ScrollPaneAdjustable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import ole.pstros.MainApp;
import ole.pstros.monitor.ClassManager;
import ole.pstros.utils.ListItem;
import ole.pstros.utils.ListViewer;

public class MonitorFrame
extends Frame
implements ItemListener {
    private static boolean initialized;
    private Choice profileChoice;
    private ListViewer listViewer;

    public void doLayout() {
        if (!initialized) {
            this.initComponents();
            initialized = true;
        }
        super.doLayout();
    }

    private void initComponents() {
        this.setTitle("Monitor");
        ClassManager cm = ClassManager.getInstance();
        BorderLayout cl = new BorderLayout();
        Panel globalPanel = new Panel(cl);
        Panel profilePanel = new Panel(new BorderLayout());
        profilePanel.add((Component)new Label("Profile"), "West");
        this.profileChoice = new Choice();
        String[] profiles = cm.getProfileNames();
        int i2 = 0;
        while (i2 < profiles.length) {
            this.profileChoice.add(profiles[i2]);
            ++i2;
        }
        this.profileChoice.addItemListener(this);
        profilePanel.add((Component)this.profileChoice, "Center");
        profilePanel.setBackground(ListViewer.COLOR_LIGHT_GRAY);
        globalPanel.add((Component)profilePanel, "North");
        ScrollPane scrollPane = new ScrollPane(0);
        this.listViewer = new ListViewer(this, scrollPane);
        this.listViewer.setColumnInfo(new String[]{"Variable", "Value"}, new int[]{160, 80});
        this.addWindowListener(this.listViewer);
        this.listViewer.setVerticalScroll((ScrollPaneAdjustable)scrollPane.getVAdjustable());
        scrollPane.add(this.listViewer);
        globalPanel.add((Component)scrollPane, "Center");
        this.add(globalPanel);
    }

    public void updateItems() {
        if (this.listViewer == null || !this.listViewer.isVisible()) {
            return;
        }
        ClassManager cm = ClassManager.getInstance();
        ListItem[] items = cm.getItems(MainApp.midlet);
        int itemCount = cm.getItemCount();
        this.listViewer.setItems(items, itemCount);
        this.listViewer.repaintItems();
    }

    public void selectProfileChoice(String name) {
        this.profileChoice.select(name);
    }

    public void itemStateChanged(ItemEvent e2) {
        ClassManager cm = ClassManager.getInstance();
        cm.setProfile((String)e2.getItem(), MainApp.midlet);
        this.listViewer.notifyProfileChange();
    }

    public void dispose() {
        this.listViewer.storeBounds();
        initialized = false;
        super.dispose();
    }
}

