/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.InputStream;
import ole.pstros.utils.DecoderListener;
import ole.pstros.utils.TgaWriter;

public class Orv2Tga {
    private static byte[] buf = new byte[8];
    private static int width;
    private static int height;
    private static int frameSize;
    public static boolean decode;

    public static void process(InputStream is, String destPath, DecoderListener listener) {
        int index = 0;
        FilterInputStream stream = null;
        try {
            try {
                stream = new DataInputStream(new BufferedInputStream(is));
                ((DataInputStream)stream).readFully(buf, 0, 8);
                if (!Orv2Tga.checkHeader()) {
                    throw new Exception("unsupported file format");
                }
                frameSize = Orv2Tga.getFrameSize();
                byte[] data = new byte[frameSize];
                decode = true;
                while (decode) {
                    int timeDiff;
                    try {
                        timeDiff = ((DataInputStream)stream).readInt();
                    }
                    catch (Exception e2) {
                        timeDiff = 0;
                    }
                    byte scrollX = ((DataInputStream)stream).readByte();
                    byte scrollY = ((DataInputStream)stream).readByte();
                    int scroll = scrollY * width + scrollX;
                    Orv2Tga.doScroll(data, scroll * 3);
                    int blockCounter = ((DataInputStream)stream).readShort();
                    int i2 = 0;
                    while (i2 < blockCounter) {
                        int pixelIndex = ((DataInputStream)stream).readInt();
                        int dataSize = ((DataInputStream)stream).readInt();
                        ((DataInputStream)stream).readFully(data, pixelIndex * 3, dataSize * 3);
                        ++i2;
                    }
                    if (listener != null) {
                        listener.decodeFrame(data, width, height);
                        if (timeDiff <= 0) continue;
                        try {
                            Thread.sleep(timeDiff);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    TgaWriter.saveImageData(destPath, data, 0, frameSize, width, height, index);
                    ++index;
                }
            }
            catch (EOFException eofe) {
                System.out.println("eof detected");
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception e3) {
                    System.out.println("!Error:Orv2Tga: " + e3);
                }
            }
            catch (Exception e4) {
                System.out.println("!Error:Orv2Tga: " + e4);
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (Exception e5) {
                    System.out.println("!Error:Orv2Tga: " + e5);
                }
            }
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (Exception e6) {
                System.out.println("!Error:Orv2Tga: " + e6);
            }
        }
    }

    private static boolean checkHeader() {
        return buf[0] == 79 && buf[1] == 82 && buf[2] == 86 && buf[3] <= 1;
    }

    private static int getFrameSize() {
        width = (buf[4] & 0xFF) + (buf[5] & 0xFF) * 256;
        height = (buf[6] & 0xFF) + (buf[7] & 0xFF) * 256;
        return width * height * 3;
    }

    private static void doScroll(byte[] data, int scroll) {
        if (scroll == 0) {
            return;
        }
        if (scroll > 0) {
            int index = 0;
            int i2 = scroll;
            while (i2 < frameSize) {
                data[index++] = data[i2];
                ++i2;
            }
            i2 = frameSize - scroll;
            while (i2 < frameSize) {
                data[i2] = 0;
                ++i2;
            }
        } else {
            int index = frameSize - 1;
            int i3 = frameSize - 1 + scroll;
            while (i3 >= 0) {
                data[index--] = data[i3];
                --i3;
            }
            int maxScroll = -scroll;
            int i4 = 0;
            while (i4 < maxScroll) {
                data[i4] = 0;
                ++i4;
            }
        }
    }
}

