/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.microedition.lcdui.Display;
import ole.pstros.ConfigData;
import ole.pstros.monitor.ClassManager;
import ole.pstros.monitor.MonitorProfile;

public class ParamWriter {
    public static final String ASSIGN = " = ";
    public static final String WINDOW_POS_X = "window.positionX";
    public static final String WINDOW_POS_Y = "window.positionY";
    public static final String CONTROL_CONFIG = "control.config";
    public static final String CONTROL_KEY_SOFT_LEFT = "control.keySoftLeft";
    public static final String CONTROL_KEY_SOFT_RIGHT = "control.keySoftRight";
    public static final String CONTROL_KEY_SOFT_RIGHT_OBSOLETE = "control.keySoftRifgt";
    public static final String CONTROL_KEY_SOFT_CENTER = "control.keySoftCenter";
    public static final String CONTROL_KEY_LEFT = "control.keyLeft";
    public static final String CONTROL_KEY_UP = "control.keyUp";
    public static final String CONTROL_KEY_RIGHT = "control.keyRight";
    public static final String CONTROL_KEY_DOWN = "control.keyDown";
    public static final String CONTROL_KEY_FIRE = "control.keyFire";
    public static final String CONTROL_KEY_NUM_0 = "control.keyNum0";
    public static final String CONTROL_KEY_NUM_7 = "control.keyNum7";
    public static final String CONTROL_KEY_NUM_8 = "control.keyNum8";
    public static final String CONTROL_KEY_NUM_9 = "control.keyNum9";
    public static final String CONTROL_KEY_NUM_4 = "control.keyNum4";
    public static final String CONTROL_KEY_NUM_5 = "control.keyNum5";
    public static final String CONTROL_KEY_NUM_6 = "control.keyNum6";
    public static final String CONTROL_KEY_NUM_1 = "control.keyNum1";
    public static final String CONTROL_KEY_NUM_2 = "control.keyNum2";
    public static final String CONTROL_KEY_NUM_3 = "control.keyNum3";
    public static final String CONTROL_KEY_STAR = "control.keyStar";
    public static final String CONTROL_KEY_CROSS = "control.keyCross";
    public static final String CONTROL_KEY_SCREEN_SHOT = "control.keyScreenShot";
    public static final String CONTROL_KEY_CAPTURE_VIDEO = "control.keyCaptureVideo";
    public static final String CONTROL_KEY_SHOW_HIDE_NOTIFY = "control.keyShowHideNotify";
    public static final String CONTROL_KEY_RESIZE_SCREEN = "control.keyResizeScreen";
    public static final String MONITOR_ENABLE = "monitor.enable";
    public static final String MONITOR_POS_X = "monitor.positionX";
    public static final String MONITOR_POS_Y = "monitor.positionY";
    public static final String MONITOR_WIDTH = "monitor.width";
    public static final String MONITOR_HEIGHT = "monitor.height";
    public static final String MONITOR_VARIABLE = "monitor.variable";
    public static final String MONITOR_PROFILE = "monitor.profile";
    public static final String IMAGE_VIEWER_POS_X = "imageViewer.positionX";
    public static final String IMAGE_VIEWER_POS_Y = "imageViewer.positionY";
    public static final String IMAGE_VIEWER_WIDTH = "imageViewer.width";
    public static final String IMAGE_VIEWER_HEIGHT = "imageViewer.height";
    public static final String ZOOM_VIEWER_SIZE = "zoomViewer.size";
    private static String endOfLine;

    public static final void saveParams() {
        if (endOfLine == null) {
            endOfLine = System.getProperty("line.separator");
        }
        try {
            FileOutputStream fos = new FileOutputStream(ParamWriter.getDataFilename());
            ParamWriter.saveParameter((OutputStream)fos, WINDOW_POS_X, ConfigData.windowPositionX);
            ParamWriter.saveParameter((OutputStream)fos, WINDOW_POS_Y, ConfigData.windowPositionY);
            ParamWriter.saveParameter((OutputStream)fos, CONTROL_CONFIG, ConfigData.controlConfig ? 1 : 0);
            if (ConfigData.controlConfig) {
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_SOFT_LEFT, Display.keySoftLeft);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_SOFT_RIGHT, Display.keySoftRight);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_SOFT_CENTER, Display.keySoftCenter);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_LEFT, Display.keyLeft);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_RIGHT, Display.keyRight);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_UP, Display.keyUp);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_DOWN, Display.keyDown);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_FIRE, Display.keyFire);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_NUM_0, Display.keyNum0);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_NUM_1, Display.keyNum1);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_NUM_2, Display.keyNum2);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_NUM_3, Display.keyNum3);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_NUM_4, Display.keyNum4);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_NUM_5, Display.keyNum5);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_NUM_6, Display.keyNum6);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_NUM_7, Display.keyNum7);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_NUM_8, Display.keyNum8);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_NUM_9, Display.keyNum9);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_STAR, Display.keyStar);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_CROSS, Display.keyCross);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_SCREEN_SHOT, Display.keyScreenShot);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_CAPTURE_VIDEO, Display.keyCaptureVideo);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_SHOW_HIDE_NOTIFY, Display.keyShowHideNotify);
                ParamWriter.saveParameter((OutputStream)fos, CONTROL_KEY_RESIZE_SCREEN, Display.keyRotate);
            }
            if (ConfigData.zoomSize > 1) {
                ParamWriter.saveParameter((OutputStream)fos, ZOOM_VIEWER_SIZE, ConfigData.zoomSize);
            }
            if (ConfigData.imageViewerBounds != null) {
                ParamWriter.saveParameter((OutputStream)fos, IMAGE_VIEWER_POS_X, ConfigData.imageViewerBounds.x);
                ParamWriter.saveParameter((OutputStream)fos, IMAGE_VIEWER_POS_Y, ConfigData.imageViewerBounds.y);
                ParamWriter.saveParameter((OutputStream)fos, IMAGE_VIEWER_WIDTH, ConfigData.imageViewerBounds.width);
                ParamWriter.saveParameter((OutputStream)fos, IMAGE_VIEWER_HEIGHT, ConfigData.imageViewerBounds.height);
            }
            ParamWriter.saveParameter((OutputStream)fos, MONITOR_ENABLE, ConfigData.classMonitor ? 1 : 0);
            if (ConfigData.classMonitor) {
                if (ConfigData.classMonitorBounds != null) {
                    ParamWriter.saveParameter((OutputStream)fos, MONITOR_POS_X, ConfigData.classMonitorBounds.x);
                    ParamWriter.saveParameter((OutputStream)fos, MONITOR_POS_Y, ConfigData.classMonitorBounds.y);
                    ParamWriter.saveParameter((OutputStream)fos, MONITOR_WIDTH, ConfigData.classMonitorBounds.width);
                    ParamWriter.saveParameter((OutputStream)fos, MONITOR_HEIGHT, ConfigData.classMonitorBounds.height);
                }
                ClassManager cm = ClassManager.getInstance();
                MonitorProfile[] profiles = cm.getProfiles();
                int size = profiles.length;
                int i2 = 0;
                while (i2 < size) {
                    MonitorProfile profile = profiles[i2];
                    ParamWriter.saveParameter((OutputStream)fos, MONITOR_PROFILE, profile.getName());
                    int varCount = profile.getSize();
                    int j2 = 0;
                    while (j2 < varCount) {
                        ParamWriter.saveParameter((OutputStream)fos, MONITOR_VARIABLE, profile.getItem(j2));
                        ++j2;
                    }
                    ++i2;
                }
            }
            fos.flush();
            fos.close();
        }
        catch (Exception e2) {
            System.out.println("Error: Pstros: ParamWriter.saveParams() " + e2);
        }
    }

    private static final void saveParameter(OutputStream os, String name, int value) throws Exception {
        os.write(name.getBytes());
        os.write(ASSIGN.getBytes());
        os.write(Integer.toString(value).getBytes());
        os.write(endOfLine.getBytes());
    }

    private static final void saveParameter(OutputStream os, String name, String value) throws Exception {
        os.write(name.getBytes());
        os.write(ASSIGN.getBytes());
        os.write(value.getBytes());
        os.write(endOfLine.getBytes());
    }

    public static String getDataFilename() {
        String dir = System.getProperty("user.home");
        File dirFile = new File(dir = String.valueOf(dir) + "/.pstros");
        if (!dirFile.exists()) {
            dirFile.mkdir();
        }
        return String.valueOf(dir) + "/params.cnf";
    }
}

