/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.util.ArrayList;

public class XmlTag {
    public static final int END_TAG_FULL = 0;
    public static final int END_TAG_SHORT = 1;
    private String name;
    private int endTagType;
    private ArrayList propertyList = new ArrayList();

    public XmlTag() {
    }

    public XmlTag(String name) {
        this.name = name;
    }

    public XmlTag(String name, String property, String value) {
        this.name = name;
        this.setProperty(property, value);
    }

    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.propertyList.size();
    }

    public String getPropertyName(int index) {
        XmlProperty p2 = (XmlProperty)this.propertyList.get(index);
        return p2.getName();
    }

    public String getPropertyValue(int index) {
        XmlProperty p2 = (XmlProperty)this.propertyList.get(index);
        return p2.getValue();
    }

    public void setName(String name) {
        this.name = name;
        this.propertyList.clear();
    }

    public void clear() {
        this.propertyList.clear();
    }

    public void setProperty(String name, String value) {
        XmlProperty p2 = new XmlProperty(name, value);
        this.propertyList.add(p2);
    }

    public void setProperty(String name, int value) {
        this.setProperty(name, Integer.toString(value));
    }

    public void setProperty(String name, boolean value) {
        this.setProperty(name, Integer.toString(value ? 1 : 0));
    }

    public void setProperty(String name, float value) {
        this.setProperty(name, Float.toString(value));
    }

    public void setEndTagType(int endTagType) {
        this.endTagType = endTagType;
    }

    public int getEndTagType() {
        return this.endTagType;
    }

    private class XmlProperty {
        private String name;
        private String value;

        public XmlProperty() {
        }

        public XmlProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

