/*
 * Decompiled with CFR 0.152.
 */
package ole.pstros.utils;

import java.io.File;
import java.io.FileOutputStream;
import ole.pstros.utils.XmlTag;

public class XmlWriter {
    protected int curLevel;
    protected StringBuffer dataBuffer;
    protected File file;

    public XmlWriter(File file) {
        this.file = file;
        this.create(true);
    }

    public XmlWriter(File file, boolean header) {
        this.file = file;
        this.create(header);
    }

    private void create(boolean header) {
        this.dataBuffer = header ? new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n") : new StringBuffer();
        this.curLevel = 0;
    }

    public void close() throws Exception {
        byte[] buff = this.dataBuffer.toString().getBytes();
        FileOutputStream dataOut = new FileOutputStream(this.file);
        dataOut.write(buff);
        dataOut.flush();
        dataOut.close();
        this.curLevel = 0;
    }

    public void newLine() {
        this.dataBuffer.append("\n");
    }

    public void comment(String text) {
        if (text == null) {
            return;
        }
        this.dataBuffer.append(this.levelSpaces()).append("<!-- ").append(text).append(" -->\n");
    }

    public void startTag(String tag) {
        String string = new String(String.valueOf(this.levelSpaces()) + "<" + tag + ">\n");
        this.dataBuffer.append(string);
        ++this.curLevel;
    }

    public void startTag(String tag, String property, String value) {
        this.dataBuffer.append(this.levelSpaces()).append('<').append(tag).append(' ').append(property).append("=\"").append(value).append("\" >\n");
        ++this.curLevel;
    }

    public void startTag(XmlTag tag) {
        String string = new String(String.valueOf(this.levelSpaces()) + "<" + tag.getName() + " ");
        if (tag.getCount() <= 0) {
            this.startTag(tag.getName());
        } else if (tag.getCount() == 1) {
            string = String.valueOf(string) + tag.getPropertyName(0) + "=\"";
            string = String.valueOf(string) + tag.getPropertyValue(0) + "\" ";
        } else {
            int max = tag.getCount();
            int i2 = 0;
            while (i2 < max) {
                string = String.valueOf(string) + "\n" + this.levelSpaces() + "    ";
                string = String.valueOf(string) + tag.getPropertyName(i2) + "=\"";
                string = String.valueOf(string) + tag.getPropertyValue(i2) + "\" ";
                ++i2;
            }
        }
        if (tag.getEndTagType() == 1) {
            string = String.valueOf(string) + "/>\n";
        } else {
            string = String.valueOf(string) + ">\n";
            ++this.curLevel;
        }
        this.dataBuffer.append(string);
    }

    public void endTag(String tag) {
        --this.curLevel;
        String string = new String(String.valueOf(this.levelSpaces()) + "</" + tag + ">\n");
        this.dataBuffer.append(string);
    }

    public void endTag(XmlTag tag) {
        this.endTag(tag.getName());
    }

    public void simpleTag(String tag, String text) {
        if (text == null) {
            this.dataBuffer.append(this.levelSpaces()).append('<').append(tag).append("></").append(tag).append(">\n");
        } else {
            this.dataBuffer.append(this.levelSpaces()).append('<').append(tag).append('>').append(text).append("</").append(tag).append(">\n");
        }
    }

    public void simpleTag(String tag, float value) {
        this.simpleTag(tag, Float.toString(value));
    }

    public void simplePropertyTag(String tag, String property, String value) {
        if (value == null) {
            this.dataBuffer.append(this.levelSpaces()).append('<').append(tag).append("></").append(tag).append(">\n");
        } else {
            this.dataBuffer.append(this.levelSpaces()).append('<').append(tag).append(' ').append(property).append("=\"").append(value).append("\" />\n");
        }
    }

    public void prepInstruction(String text) {
        if (text == null) {
            return;
        }
        this.dataBuffer.append(this.levelSpaces()).append("<?").append(text).append("?>\n");
    }

    public void cppCommand(String text) {
        if (text == null) {
            return;
        }
        this.dataBuffer.append('\n').append(text).append('\n');
    }

    public void simpleTag(String tag, int[] values) {
        if (values == null) {
            return;
        }
        int size = values.length;
        StringBuffer xmlBuffer = new StringBuffer(size * 4);
        int i2 = 0;
        while (i2 < size) {
            xmlBuffer.append(values[i2]);
            xmlBuffer.append(' ');
            ++i2;
        }
        this.simpleTag(tag, xmlBuffer.toString());
    }

    public void simpleTag(String tag, byte[] values) {
        if (values == null) {
            return;
        }
        int size = values.length;
        StringBuffer xmlBuffer = new StringBuffer(size * 2);
        int i2 = 0;
        while (i2 < size) {
            xmlBuffer.append(values[i2]);
            xmlBuffer.append(' ');
            ++i2;
        }
        this.simpleTag(tag, xmlBuffer.toString());
    }

    public void simpleTag(String tag, float[] values) {
        if (values == null) {
            return;
        }
        int size = values.length;
        StringBuffer xmlBuffer = new StringBuffer(size * 8);
        int i2 = 0;
        while (i2 < size) {
            xmlBuffer.append(values[i2]);
            xmlBuffer.append(' ');
            ++i2;
        }
        this.simpleTag(tag, xmlBuffer.toString());
    }

    public void simpleTag(String tag, float[] values, int groupCount) {
        if (values == null) {
            return;
        }
        int size = values.length;
        StringBuffer xmlBuffer = new StringBuffer(size * 8);
        int i2 = 0;
        while (i2 < size) {
            if (i2 % groupCount == 0) {
                xmlBuffer.append("\n").append(this.levelSpaces()).append("    ");
            }
            xmlBuffer.append(values[i2]);
            xmlBuffer.append(' ');
            ++i2;
        }
        xmlBuffer.append("\n").append(this.levelSpaces());
        this.simpleTag(tag, xmlBuffer.toString());
    }

    public void simpleTag(String tag, int value) {
        this.simpleTag(tag, Integer.toString(value));
    }

    public int getLevel() {
        return this.curLevel;
    }

    public void setLevel(int level) {
        this.curLevel = level;
    }

    private String levelSpaces() {
        String string = new String("");
        int i2 = 0;
        while (i2 < this.curLevel) {
            string = String.valueOf(string) + "\t";
            ++i2;
        }
        return string;
    }
}

